/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.DateUtil;

public class PackageActionInfoDto {
    private static final Logger LOG = LoggerFactory.getLogger(PackageActionInfoDto.class);
    private final String date;
    private final String executedBy;

    private PackageActionInfoDto(String date, String executedBy) {
        this.date = date;
        this.executedBy = executedBy;
    }

    public String getDate() {
        return this.date;
    }

    public String getExecutedBy() {
        return this.executedBy;
    }

    static PackageActionInfoDto create(JcrPackageDefinition packageDefinition, String actionPropName) {
        Calendar actionDate;
        if (packageDefinition != null && (actionDate = packageDefinition.getCalendar(actionPropName)) != null) {
            String date = DateUtil.format(actionDate);
            String executedBy = packageDefinition.get(actionPropName + "By");
            return new PackageActionInfoDto(date, executedBy);
        }
        return null;
    }

    static PackageActionInfoDto createUploadPackageInfo(Node packageNode) {
        if (packageNode == null) {
            return null;
        }
        try {
            LOG.info("Package {} built date does not exist, using upload date", (Object)packageNode.getPath());
            if (packageNode.hasProperty("jcr:created")) {
                Property uploadProp = packageNode.getProperty("jcr:created");
                String uploadDate = DateUtil.format(uploadProp.getDate());
                return new PackageActionInfoDto(uploadDate, PackageActionInfoDto.getUploadedBy(packageNode));
            }
        }
        catch (RepositoryException e) {
            LOG.warn("Could not fetch upload date", (Throwable)e);
        }
        return null;
    }

    private static String getUploadedBy(Node packageNode) throws RepositoryException {
        Property uploadedByProp;
        if (packageNode.hasProperty("jcr:createdBy") && !(uploadedByProp = packageNode.getProperty("jcr:createdBy")).isMultiple()) {
            return PropertiesUtil.toString((Object)uploadedByProp.getValue(), null);
        }
        return null;
    }
}

