/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageThumbnailDto {
    private static final Logger LOG = LoggerFactory.getLogger(PackageThumbnailDto.class);
    private final String path;
    private final long timestamp;

    private PackageThumbnailDto(String path, long timestamp) {
        this.path = path;
        this.timestamp = timestamp;
    }

    public static PackageThumbnailDto forPackagePath(String packagePath, Session session) {
        try {
            String packageThumbnailPath = packagePath + "/jcr:content/vlt:definition/thumbnail.png";
            if (!session.nodeExists(packageThumbnailPath)) {
                return null;
            }
            Node packageThumbnailNode = session.getNode(packageThumbnailPath);
            if (!packageThumbnailNode.hasNode("jcr:content")) {
                return null;
            }
            Node thumbnailContentNode = packageThumbnailNode.getNode("jcr:content");
            if (!thumbnailContentNode.isNodeType("{http://www.jcp.org/jcr/nt/1.0}resource")) {
                return null;
            }
            Calendar lastModificationDate = thumbnailContentNode.hasProperty("jcr:lastModified") ? thumbnailContentNode.getProperty("jcr:lastModified").getDate() : null;
            return lastModificationDate != null ? new PackageThumbnailDto(packageThumbnailPath, lastModificationDate.getTimeInMillis()) : null;
        }
        catch (RepositoryException e) {
            LOG.warn("Could not check package thumbnail", (Throwable)e);
            return null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

