/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.packageaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.PackageLogUtil;

public class PackageActionLogProgressListener
implements ProgressTrackerListener {
    private static final Logger LOG = LoggerFactory.getLogger(PackageActionLogProgressListener.class);
    private final ModifiableValueMap logValueMap;
    private final ResourceResolver resolver;
    private final List<String> entries = new ArrayList<String>();
    private final String jobId;
    private String[] searchPathPrefixes;
    private String[] overlayablePathPrefixes;
    private long lastCommitTimeInMillis = 0L;
    private String range = "0-1000";
    private boolean signedByJob;

    public PackageActionLogProgressListener(ModifiableValueMap logValueMap, ResourceResolver resolver, List<String> resolverSearchPaths, String jobId) {
        this.logValueMap = logValueMap;
        this.resolver = resolver;
        this.jobId = jobId;
        if (PackageActionLogProgressListener.isOverlayPossible(resolverSearchPaths)) {
            this.searchPathPrefixes = (String[])resolverSearchPaths.stream().map(path -> StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0])).distinct().toArray(String[]::new);
            ArrayUtils.reverse((Object[])this.searchPathPrefixes);
            this.overlayablePathPrefixes = (String[])ArrayUtils.remove((Object[])this.searchPathPrefixes, (int)(this.searchPathPrefixes.length - 1));
        }
    }

    private static boolean isOverlayPossible(List<String> resolverSearchPaths) {
        return resolverSearchPaths.size() > 1;
    }

    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        this.processLog(this.getInfoLogMessages(action, path));
    }

    private List<String> getInfoLogMessages(String action, String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return Collections.singletonList(action);
        }
        ArrayList<String> logMessages = new ArrayList<String>();
        logMessages.add(String.format("%s %s", action, path));
        if (this.searchPathPrefixes != null && this.overlayablePathPrefixes.length > 0) {
            this.validateOverlay(path, logMessages);
        }
        return logMessages;
    }

    private void validateOverlay(String path, List<String> logMessages) {
        Arrays.stream(this.overlayablePathPrefixes).filter(path::startsWith).map(overlayablePathCandidate -> PackageActionLogProgressListener.detectOverlay(overlayablePathCandidate, path, this.searchPathPrefixes, this.resolver)).filter(Objects::nonNull).findFirst().ifPresent(overlayPath -> logMessages.add("Potential ResourceResolver overlay found: " + overlayPath + " for processed path: " + path));
    }

    private static String detectOverlay(String overlayPathPrefix, String sourcePath, String[] searchPathPrefixes, ResourceResolver resolver) {
        String[] possibleOverlays;
        for (String possibleOverlay : possibleOverlays = (String[])ArrayUtils.subarray((Object[])searchPathPrefixes, (int)(ArrayUtils.indexOf((Object[])searchPathPrefixes, (Object)overlayPathPrefix) + 1), (int)searchPathPrefixes.length)) {
            String possibleOverlayPath = possibleOverlay + sourcePath.substring(overlayPathPrefix.length());
            if (resolver.getResource(possibleOverlayPath) == null) continue;
            return possibleOverlayPath;
        }
        return null;
    }

    public void onError(ProgressTrackerListener.Mode mode, String path, Exception e) {
        this.processLog(Collections.singletonList(String.format("E %s (%s)", path, e)));
    }

    private void processLog(List<String> logMessages) {
        this.entries.addAll(logMessages);
        long lastChangeTimeInMillis = System.currentTimeMillis();
        if (Math.abs(lastChangeTimeInMillis - this.lastCommitTimeInMillis) > 1000L) {
            this.lastCommitTimeInMillis = lastChangeTimeInMillis;
            this.commitLog();
        }
    }

    public void flushUnsavedData() {
        if (!this.entries.isEmpty()) {
            this.commitLog();
        }
    }

    private void commitLog() {
        this.signLogs();
        while (this.entries.size() >= 1000) {
            List<String> fullEntry = this.entries.subList(0, 1000);
            PackageLogUtil.putLog(this.logValueMap, this.range, fullEntry);
            this.range = PackageLogUtil.increaseRange(this.range);
            this.entries.removeAll(fullEntry);
        }
        PackageLogUtil.putLog(this.logValueMap, this.range, this.entries);
        try {
            this.resolver.commit();
        }
        catch (PersistenceException e) {
            LOG.warn("Could not update logs during package action", (Throwable)e);
        }
    }

    private void signLogs() {
        if (!this.signedByJob) {
            this.logValueMap.put((Object)"logAuthorId", (Object)this.jobId);
            this.signedByJob = true;
        }
    }
}

