/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.dto.PackageUploadDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.PackagePathSaveHelper;
import pl.ds.websight.packagemanager.rest.UploadPackageRestModel;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;

public abstract class AbstractUploadableRestAction
extends AbstractRestAction<UploadPackageRestModel, PackageUploadDto>
implements RestAction<UploadPackageRestModel, PackageUploadDto> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUploadableRestAction.class);
    private static final String VALID_CONTENT_TYPE_PREFIX = "multipart";
    protected Packaging packaging;

    protected abstract void setPackaging(Packaging var1);

    protected RestActionResult<PackageUploadDto> performUpload(UploadPackageRestModel model) throws IOException, RepositoryException {
        return this.performUpload(model, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected RestActionResult<PackageUploadDto> performUpload(UploadPackageRestModel model, PackagePathSaveHelper pathSaveHelper) throws IOException, RepositoryException {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)model.getRequestContentType(), (CharSequence)"multipart/")) {
            return RestActionResult.failure((String)"Could not upload package", (String)Messages.formatMessage("Content Type of request is not '%s'", VALID_CONTENT_TYPE_PREFIX));
        }
        if (model.getFileParam().isFormField()) {
            return RestActionResult.failure((String)"Could not upload package", (String)"Parameter 'file' should be a file");
        }
        try (InputStream packageStream = model.getFileParam().getInputStream();){
            RestActionResult restActionResult;
            block17: {
                JcrPackage uploadedPackage = this.uploadPackage(packageStream, model.getSession(), model.isForce());
                try {
                    LOG.debug("Successfully uploaded a package");
                    if (pathSaveHelper != null) {
                        pathSaveHelper.setPathRequestAttribute(uploadedPackage.getNode());
                    }
                    restActionResult = RestActionResult.success((String)"Package uploaded", (String)Messages.formatMessage("Package '%s' has been uploaded", JcrPackageUtil.getSimplePackageName(uploadedPackage)), (Object)new PackageUploadDto(this.getPath(uploadedPackage)));
                    if (uploadedPackage == null) break block17;
                }
                catch (Throwable throwable) {
                    if (uploadedPackage != null) {
                        try {
                            uploadedPackage.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                uploadedPackage.close();
            }
            return restActionResult;
        }
        catch (ItemExistsException e) {
            return RestActionResult.failure((String)"Could not upload package", (String)"Uploaded package already exists");
        }
    }

    private String getPath(JcrPackage uploadedPackage) throws RepositoryException {
        Node packageNode = Optional.ofNullable(uploadedPackage).map(JcrPackage::getNode).orElse(null);
        if (packageNode != null) {
            return packageNode.getPath();
        }
        return "";
    }

    private JcrPackage uploadPackage(InputStream packageStream, Session session, boolean force) throws IOException, RepositoryException {
        LOG.debug("Starting package upload");
        JcrPackageManager manager = this.packaging.getPackageManager(session);
        return manager.upload(packageStream, force);
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not upload package";
    }
}

