/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.PackageFinder;
import pl.ds.websight.packagemanager.dto.PackageActionDto;
import pl.ds.websight.packagemanager.dto.PackageDto;
import pl.ds.websight.packagemanager.dto.PackageListDto;
import pl.ds.websight.packagemanager.dto.PackageScheduleActionInfoDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.FindPackagesRestModel;
import pl.ds.websight.packagemanager.rest.PackageDefinition;
import pl.ds.websight.packagemanager.rest.requestparameters.FilterOption;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
@Designate(ocd=Config.class)
public class FindPackagesRestAction
extends AbstractRestAction<FindPackagesRestModel, PackageListDto>
implements RestAction<FindPackagesRestModel, PackageListDto> {
    private static final Logger LOG = LoggerFactory.getLogger(FindPackagesRestAction.class);
    private static final int LIMITED_NEXT_PAGES = 3;
    @Reference
    private Packaging packaging;
    @Reference
    private JobManager jobManager;
    private Config config;

    @Override
    protected RestActionResult<PackageListDto> performAction(FindPackagesRestModel model) throws RepositoryException {
        return RestActionResult.success((Object)this.findPackages(model));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageListDto findPackages(FindPackagesRestModel model) throws RepositoryException {
        Session session = model.getSession();
        if (session == null || !session.nodeExists("/etc/packages/")) {
            LOG.debug("User is not allowed to read packages");
            return PackageListDto.EMPTY;
        }
        List<Object> fetchedPackages = new LinkedList<JcrPackage>();
        try {
            JcrPackageManager packageManager = this.packaging.getPackageManager(session);
            String group = FindPackagesRestAction.getRequestedOrPackageGroupIfBothRequested(model, packageManager);
            boolean groupRequested = !":no_group".equals(group);
            String packagesSearchPath = FindPackagesRestAction.getPackagesSearchPath(group, groupRequested);
            boolean limitExceeded = false;
            if (session.nodeExists(packagesSearchPath)) {
                Node searchRootNode = session.getNode(packagesSearchPath);
                long allPackagesCount = JcrPackageUtil.countPackages(searchRootNode, this.config.count_limit(), groupRequested);
                if (allPackagesCount > (long)this.config.count_limit()) {
                    limitExceeded = true;
                    long limit = PackageFinder.getOffset(model.getPageNumber()) + 75L;
                    fetchedPackages = FindPackagesRestAction.fetchPackagesLimited(new ArrayList<String>(), model, packageManager, searchRootNode, limit, groupRequested, this.jobManager);
                } else {
                    fetchedPackages = FindPackagesRestAction.fetchPackages(searchRootNode, model.getPackageNameFilter(), groupRequested).stream().sorted(model.getSortBy().getComparator()).map(definition -> FindPackagesRestAction.openPackage(packageManager, definition.getPackageNode())).filter(Objects::nonNull).collect(Collectors.toList());
                }
            }
            List<JcrPackage> foundPackages = this.filterPackagesIfNeeded(fetchedPackages, model, limitExceeded, session);
            long foundPackagesCount = foundPackages.size();
            long numberOfPages = PackageFinder.getNumberOfPages(foundPackagesCount);
            long pageNumber = FindPackagesRestAction.getPageNumber(model, foundPackages);
            long offset = PackageFinder.getOffset(pageNumber);
            List<PackageDto> packages = this.getPackagesForRequestedPage(foundPackages, session, offset);
            PackageListDto packageListDto = new PackageListDto(foundPackagesCount, limitExceeded, numberOfPages, pageNumber, this.config.count_limit(), group, packages);
            return packageListDto;
        }
        finally {
            fetchedPackages.forEach(JcrPackageUtil::close);
        }
    }

    private static String getRequestedOrPackageGroupIfBothRequested(FindPackagesRestModel model, JcrPackageManager packageManager) {
        String requestedPackagePath = model.getPath();
        String requestedGroup = model.getGroup();
        if (StringUtils.isNotBlank((CharSequence)requestedPackagePath) && StringUtils.isNotBlank((CharSequence)requestedGroup)) {
            try {
                Node requestedPackageNode = model.getSession().getNode(requestedPackagePath);
                if (requestedPackageNode != null) {
                    Node requestedPackageGroupNode = requestedPackageNode.getParent();
                    String groupIdFromNode = JcrPackageUtil.getGroupIdFromNode(packageManager.getPackageRoot(), requestedPackageGroupNode);
                    return StringUtils.isNotBlank((CharSequence)groupIdFromNode) ? groupIdFromNode : ":no_group";
                }
            }
            catch (RepositoryException e) {
                LOG.warn("Could not open JCR package for path {}", (Object)requestedPackagePath, (Object)e);
            }
        }
        return requestedGroup;
    }

    private static String getPackagesSearchPath(String group, boolean hasGroup) {
        if (hasGroup) {
            return "/etc/packages/" + StringUtils.defaultString((String)group, (String)"");
        }
        return "/etc/packages/";
    }

    private static List<JcrPackage> fetchPackagesLimited(List<String> paths, FindPackagesRestModel model, JcrPackageManager packageManager, Node root, long limit, boolean deep, JobManager jobManager) throws RepositoryException {
        ArrayList<JcrPackage> packages = new ArrayList<JcrPackage>();
        NodeIterator nodeIterator = root.getNodes();
        while (nodeIterator.hasNext() && FindPackagesRestAction.isBelowLimitOrShouldSearch(paths, model.getPath(), limit)) {
            Node child = nodeIterator.nextNode();
            String name = child.getName();
            if (".snapshot".equals(name)) continue;
            if (JcrPackageUtil.isValidPackageNode(child) && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)model.getPackageNameFilter())) {
                JcrPackage jcrPackage = FindPackagesRestAction.openPackage(packageManager, child);
                if (jcrPackage == null || !FindPackagesRestAction.matchesAllFilters(jcrPackage, model.getFilterOptions(), model.getUserID(), jobManager)) continue;
                packages.add(jcrPackage);
                paths.add(child.getPath());
                continue;
            }
            if (!deep || !child.hasNodes()) continue;
            packages.addAll(FindPackagesRestAction.fetchPackagesLimited(paths, model, packageManager, child, limit, true, jobManager));
        }
        return packages;
    }

    private static boolean isBelowLimitOrShouldSearch(List<String> paths, String searchedPackagePath, long limit) {
        if (StringUtils.isBlank((CharSequence)searchedPackagePath)) {
            return (long)paths.size() < limit;
        }
        int indexOfSearchedPackage = paths.indexOf(searchedPackagePath);
        return indexOfSearchedPackage == -1 || paths.size() - indexOfSearchedPackage < 75;
    }

    private static List<PackageDefinition> fetchPackages(Node root, String filterPhrase, boolean deep) throws RepositoryException {
        ArrayList<PackageDefinition> packages = new ArrayList<PackageDefinition>();
        NodeIterator nodeIterator = root.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            String name = child.getName();
            if (".snapshot".equals(name)) continue;
            if (JcrPackageUtil.isValidPackageNode(child) && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)filterPhrase)) {
                packages.add(new PackageDefinition(child));
                continue;
            }
            if (!deep || !child.hasNodes()) continue;
            packages.addAll(FindPackagesRestAction.fetchPackages(child, filterPhrase, true));
        }
        return packages;
    }

    private static JcrPackage openPackage(JcrPackageManager packageManager, Node packageNode) {
        try {
            return packageManager.open(packageNode);
        }
        catch (RepositoryException e) {
            LOG.warn("Error while opening package", (Throwable)e);
            return null;
        }
    }

    private List<JcrPackage> filterPackagesIfNeeded(List<JcrPackage> packages, FindPackagesRestModel model, boolean limitExceeded, Session session) {
        List<FilterOption> filterOptions = model.getFilterOptions();
        if (limitExceeded || filterOptions.isEmpty()) {
            return packages;
        }
        String userId = session.getUserID();
        return packages.stream().filter(jcrPackage -> FindPackagesRestAction.matchesAllFilters(jcrPackage, filterOptions, userId, this.jobManager)).collect(Collectors.toList());
    }

    private static boolean matchesAllFilters(JcrPackage jcrPackage, List<FilterOption> filterOptions, String userID, JobManager jobManager) {
        return filterOptions == null || filterOptions.stream().allMatch(filterOption -> filterOption.matches(jcrPackage, userID, jobManager));
    }

    private static long getPageNumber(FindPackagesRestModel model, List<JcrPackage> filteredPackages) {
        long pageNumber = model.getPageNumber();
        String packagePath = model.getPath();
        if (StringUtils.isNotBlank((CharSequence)packagePath)) {
            OptionalLong pageWithPackage = PackageFinder.findPageWithPackage(packagePath, filteredPackages);
            pageNumber = pageWithPackage.orElse(pageNumber);
        }
        return pageNumber;
    }

    private List<PackageDto> getPackagesForRequestedPage(List<JcrPackage> packages, Session session, long offset) {
        List<PackageDto> packagesDtos = packages.stream().skip(offset).limit(25L).map(jcrPackage -> PackageDto.wrapWithoutJobsData(jcrPackage, session)).collect(Collectors.toList());
        String[] packagesPaths = (String[])packagesDtos.stream().map(PackageDto::getPath).toArray(String[]::new);
        Map<String, ScheduledJobInfo> nextExecutionDateByPath = JobUtil.getNearestScheduledJobs(this.jobManager, packagesPaths);
        Map<String, PackageActionDto> packagesActionsByPath = PackageActionDto.forPackagePaths(this.jobManager, session, packagesPaths);
        for (PackageDto packageDto : packagesDtos) {
            String packagePath = packageDto.getPath();
            ScheduledJobInfo nextSchedule = nextExecutionDateByPath.get(packagePath);
            if (nextSchedule != null) {
                packageDto.setNextScheduledAction(PackageScheduleActionInfoDto.asBasicInfo(nextSchedule));
            }
            packageDto.setLastAction(packagesActionsByPath.getOrDefault(packagePath, PackageActionDto.UNKNOWN));
        }
        return packagesDtos;
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not fetch packages";
    }

    @Activate
    private void activate(Config config) {
        this.config = config;
    }

    @ObjectClassDefinition(name="WebSight Package Manager: Find Packages Rest Action Configuration")
    public static @interface Config {
        @AttributeDefinition(name="Package count limit", description="Maximum number of packages traversed by 'find-packages' action.", type=AttributeType.INTEGER)
        public int count_limit() default 10000;
    }
}

