/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.util.Calendar;
import java.util.Objects;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PackageDefinition.class);
    private final Node packageNode;
    private Calendar created;
    private Calendar lastModified;
    private Calendar lastUnpacked;
    private Calendar lastUnwrapped;
    private Calendar lastWrapped;
    private String name;

    public PackageDefinition(Node packageNode) {
        this.packageNode = packageNode;
        try {
            Node content;
            this.name = packageNode.getName();
            if (packageNode.hasNode("jcr:content") && (content = packageNode.getNode("jcr:content")).hasNode("vlt:definition")) {
                Node definition = content.getNode("vlt:definition");
                this.created = this.getCalendarProperty(definition, "jcr:created");
                this.lastModified = this.getCalendarProperty(definition, "jcr:lastModified");
                this.lastUnpacked = this.getCalendarProperty(definition, "lastUnpacked");
                this.lastUnwrapped = this.getCalendarProperty(definition, "lastUnwrapped");
                this.lastWrapped = this.getCalendarProperty(definition, "lastWrapped");
            }
        }
        catch (RepositoryException e) {
            LOG.warn("Could not get property of package Node", (Throwable)e);
        }
    }

    private Calendar getCalendarProperty(Node node, String name) throws RepositoryException {
        if (node.hasProperty(name)) {
            return node.getProperty(name).getDate();
        }
        return null;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public Calendar getLastUnpacked() {
        return this.lastUnpacked;
    }

    public Calendar getLastUnwrapped() {
        return this.lastUnwrapped;
    }

    public String getName() {
        return this.name;
    }

    public Node getPackageNode() {
        return this.packageNode;
    }

    public Calendar getLatestActionDate() {
        return Stream.of(this.created, this.lastModified, this.lastUnpacked, this.lastUnwrapped, this.lastWrapped).filter(Objects::nonNull).max(Calendar::compareTo).orElse(null);
    }
}

