/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.JcrPackage;

public class PackagePrerequisiteValidator {
    private final Predicate<JcrPackage> prerequisite;
    private final String simpleMessage;
    private final UnaryOperator<String> extendedMessageGenerator;

    public PackagePrerequisiteValidator(Predicate<JcrPackage> prerequisite, String simpleMessage, UnaryOperator<String> extendedMessageGenerator) {
        this.prerequisite = prerequisite;
        this.simpleMessage = simpleMessage;
        this.extendedMessageGenerator = extendedMessageGenerator;
    }

    public boolean failPrerequisite(JcrPackage jcrPackage) {
        return !this.prerequisite.test(jcrPackage);
    }

    public String getSimpleMessage() {
        return this.simpleMessage;
    }

    public String getExtendedMessage(String packagePath) {
        return (String)this.extendedMessageGenerator.apply(packagePath);
    }

    public static Pair<String, String> getValidationResult(PackagePrerequisiteValidator[] validators, JcrPackage packageToValidate, String packagePath) {
        if (validators != null) {
            for (PackagePrerequisiteValidator validator : validators) {
                if (!validator.failPrerequisite(packageToValidate)) continue;
                return ImmutablePair.of((Object)validator.getSimpleMessage(), (Object)validator.getExtendedMessage(packagePath));
            }
        }
        return ImmutablePair.nullPair();
    }
}

