/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jcr.Session;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.rest.framework.Errors;
import pl.ds.websight.rest.framework.Validatable;

@Model(adaptables={SlingHttpServletRequest.class})
public class PackageRestModel
implements Validatable {
    private static final Logger LOG = LoggerFactory.getLogger(PackageRestModel.class);
    private static final String THUMBNAIL_PARAM_NAME = "thumbnail";
    private static final long THUMBNAIL_SIZE_LIMIT_IN_KB = 400L;
    private static final long THUMBNAIL_SIZE_LIMIT_IN_BYTES = 409600L;
    private static final List<String> SUPPORTED_PACKAGE_EXTENSIONS = Arrays.asList(".zip", ".jar");
    private static final List<String> ALLOWED_THUMBNAIL_MIME_TYPES = Arrays.asList("image/bmp", "image/gif", "image/jpeg", "image/jpg", "image/png");
    private static final CollectionType LIST_STRING_COLLECTION_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, String.class);
    private static final CollectionType LIST_FILTER_COLLECTION_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, FilterInput.class);
    private static final ObjectReader LIST_READER = new ObjectMapper().readerFor((JavaType)LIST_STRING_COLLECTION_TYPE);
    private static final ObjectReader FILTERS_INPUT_READER = new ObjectMapper().readerFor((JavaType)LIST_FILTER_COLLECTION_TYPE);
    @Self
    private SlingHttpServletRequest request;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @NotBlank(message="Package name cannot be blank")
    private @NotBlank(message="Package name cannot be blank") String name;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @NotNull(message="Package group cannot be null")
    private @NotNull(message="Package group cannot be null") String group;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    private String description;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @Default(values={""})
    private String version;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter(name="filters")
    private String filtersJson;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter(name="acHandling")
    private String acHandlingStr;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter(name="dependencies")
    private String dependenciesJson;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @Default(booleanValues={false})
    private Boolean requiresRestart;
    private List<PathFilterSet> filters;
    private List<Dependency> dependencies;
    private RequestParameter thumbnail;
    private AccessControlHandling acHandling;

    @PostConstruct
    protected void init() {
        this.filters = StringUtils.isBlank((CharSequence)this.filtersJson) ? Collections.emptyList() : PackageRestModel.readFiltersInput(this.filtersJson).stream().filter(Objects::nonNull).distinct().map(PackageRestModel::mapToPathFilterSet).collect(Collectors.toList());
        this.dependencies = StringUtils.isBlank((CharSequence)this.dependenciesJson) ? Collections.emptyList() : PackageRestModel.readJsonList(this.dependenciesJson).stream().distinct().filter(StringUtils::isNotBlank).map(Dependency::fromString).filter(Objects::nonNull).collect(Collectors.toList());
        this.acHandling = JcrPackageUtil.toAcHandling(this.acHandlingStr);
        this.thumbnail = this.request.getRequestParameter(THUMBNAIL_PARAM_NAME);
    }

    private static List<String> readJsonList(String json) {
        try {
            return (List)LIST_READER.readValue(json);
        }
        catch (IOException e) {
            LOG.warn("Could not read filter parameter", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<FilterInput> readFiltersInput(String filtersInputJson) {
        try {
            return (List)FILTERS_INPUT_READER.readValue(filtersInputJson);
        }
        catch (IOException e) {
            LOG.warn("Could not read filters input", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public SlingHttpServletRequest getRequest() {
        return this.request;
    }

    public Session getSession() {
        return (Session)this.request.getResourceResolver().adaptTo(Session.class);
    }

    public ResourceResolver getResourceResolver() {
        return this.request.getResourceResolver();
    }

    public List<PathFilterSet> getFilters() {
        return this.filters;
    }

    public AccessControlHandling getAcHandling() {
        return this.acHandling;
    }

    public boolean requiresRestart() {
        return Boolean.TRUE.equals(this.requiresRestart);
    }

    public RequestParameter getThumbnail() {
        return this.thumbnail;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    private static PathFilterSet mapToPathFilterSet(FilterInput filterInput) {
        PathFilterSet pathFilterSet = new PathFilterSet(filterInput.root);
        pathFilterSet.setImportMode(filterInput.mode);
        if (filterInput.rules == null || filterInput.rules.isEmpty()) {
            return pathFilterSet;
        }
        filterInput.rules.stream().filter(ruleInput -> StringUtils.isNotBlank((CharSequence)((RuleInput)ruleInput).path)).forEach(ruleInput -> {
            if (((RuleInput)ruleInput).include) {
                pathFilterSet.addInclude((Filter)new DefaultPathFilter(((RuleInput)ruleInput).path));
            } else {
                pathFilterSet.addExclude((Filter)new DefaultPathFilter(((RuleInput)ruleInput).path));
            }
        });
        return pathFilterSet;
    }

    public Errors validate() {
        Errors errors = Errors.createErrors();
        if (!this.group.isEmpty() && StringUtils.isBlank((CharSequence)this.group)) {
            errors.add("group", (Object)this.group, "Package group cannot contain only whitespaces");
        }
        if (!PackageId.isValid((String)this.group, (String)this.name, (String)this.version)) {
            errors.add("name", (Object)this.name, "Invalid combination of name, group and version");
            errors.add("group", (Object)this.group, "Invalid combination of name, group and version");
            errors.add("version", (Object)this.version, "Invalid combination of name, group and version");
        }
        this.validatePackagePath(errors);
        this.validateThumbnail(this.thumbnail, errors);
        return errors;
    }

    private void validatePackagePath(Errors errors) {
        ResourceResolver resourceResolver = this.getResourceResolver();
        String packagePath = "/etc/packages/" + (this.group.isEmpty() ? "" : this.group + '/') + this.name;
        String groupPath = "/etc/packages/" + this.group;
        if (!this.group.isEmpty()) {
            for (String extension : SUPPORTED_PACKAGE_EXTENSIONS) {
                if (resourceResolver.getResource(groupPath + extension) == null) continue;
                errors.add("group", (Object)this.group, String.format("Package or group under path '%s' already exists", groupPath + extension));
            }
        }
        if (resourceResolver.getResource(packagePath) != null) {
            errors.add("name", (Object)this.name, String.format("Package or group under path '%s' already exists", packagePath));
        }
    }

    private void validateThumbnail(RequestParameter thumbnail, Errors errors) {
        if (thumbnail == null) {
            return;
        }
        String mimeType = thumbnail.getContentType();
        if (!ALLOWED_THUMBNAIL_MIME_TYPES.contains(mimeType)) {
            errors.add(THUMBNAIL_PARAM_NAME, (Object)mimeType, "Allowed image types are: BMP, GIF, JPG, JPEG, PNG");
            return;
        }
        long thumbnailSize = thumbnail.getSize();
        if (thumbnailSize > 409600L) {
            errors.add(THUMBNAIL_PARAM_NAME, (Object)thumbnailSize, "Maximum file size is 400 KB");
        }
    }

    private static final class RuleInput {
        private String path;
        private boolean include;

        private RuleInput() {
        }

        public String getPath() {
            return this.path;
        }

        public boolean isInclude() {
            return this.include;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleInput ruleInput = (RuleInput)o;
            return this.include == ruleInput.include && Objects.equals(this.path, ruleInput.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.include);
        }
    }

    private static final class FilterInput {
        private static final String DEFAULT_PATH = "/";
        private String root = "/";
        private ImportMode mode = ImportMode.REPLACE;
        private List<RuleInput> rules;

        private FilterInput() {
        }

        @JsonSetter
        public void setRoot(String root) {
            this.root = ((String)StringUtils.defaultIfBlank((CharSequence)root, (CharSequence)DEFAULT_PATH)).trim();
        }

        @JsonSetter
        public void setMode(String mode) {
            this.mode = JcrPackageUtil.toImportMode(mode);
        }

        public String getRoot() {
            return this.root;
        }

        public ImportMode getMode() {
            return this.mode;
        }

        public List<RuleInput> getRules() {
            return this.rules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterInput that = (FilterInput)o;
            return Objects.equals(this.root, that.root) && Objects.equals(this.rules, that.rules);
        }

        public int hashCode() {
            return Objects.hash(this.root, this.rules);
        }
    }
}

