/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Session;
import javax.validation.constraints.NotEmpty;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import pl.ds.websight.request.parameters.support.annotations.RequestParameter;
import pl.ds.websight.rest.framework.Errors;
import pl.ds.websight.rest.framework.Validatable;

@Model(adaptables={SlingHttpServletRequest.class})
public class GetPackagesActionsStatesRestModel
implements Validatable {
    @SlingObject
    private ResourceResolver resolver;
    @RequestParameter(name="path")
    @NotEmpty(message="Packages paths cannot be empty")
    private @NotEmpty(message="Packages paths cannot be empty") List<String> paths;

    public Session getSession() {
        return (Session)this.resolver.adaptTo(Session.class);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Errors validate() {
        Errors errors = Errors.createErrors();
        List invalidPaths = this.paths.stream().filter(path -> !path.startsWith("/etc/packages/")).collect(Collectors.toList());
        return invalidPaths.isEmpty() ? errors : errors.add("path", invalidPaths, "Selected paths must start with '/etc/packages/'");
    }
}

