/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import java.util.Collections;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.dto.CombinedActionsDto;
import pl.ds.websight.packagemanager.dto.PackageActionStateDto;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobProperties;
import pl.ds.websight.packagemanager.packageoptions.PackageImportOptions;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.PackagePrerequisiteValidator;
import pl.ds.websight.packagemanager.rest.requestparameters.PackageActionCommand;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.OpenPackageException;
import pl.ds.websight.rest.framework.RestActionResult;

@Component(service={PackageActionProcessor.class})
public class PackageActionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PackageActionProcessor.class);
    private static final Map<String, Boolean> FIRST_ACTION_DONE_FLAG = Collections.singletonMap("firstActionDone", true);
    @Reference
    private Packaging packaging;
    @Reference
    private JobManager jobManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RestActionResult<PackageActionStateDto> process(String packageToProcessPath, PackageImportOptions packageImportOptions, Session session, PackageActionCommand command, PackagePrerequisiteValidator ... validators) throws RepositoryException {
        try (JcrPackage packageToProcess = JcrPackageUtil.open(packageToProcessPath, session, this.packaging.getPackageManager(session));){
            Pair<String, String> validationResult = PackagePrerequisiteValidator.getValidationResult(validators, packageToProcess, packageToProcessPath);
            if (!validationResult.equals((Object)ImmutablePair.nullPair())) {
                RestActionResult restActionResult = RestActionResult.failure((String)((String)validationResult.getKey()), (String)((String)validationResult.getValue()));
                return restActionResult;
            }
            Job runningQueuedJob = JobUtil.findFirstRunningOrQueuedJob(this.jobManager, PackageActionJobProperties.asQueryMap(packageToProcessPath));
            if (runningQueuedJob != null) {
                PackageActionCommand actionBlocker = PackageActionCommand.fetchByJobTopic(runningQueuedJob.getTopic());
                String actionBlockerName = actionBlocker != null ? actionBlocker.getActionTitle().toLowerCase(JcrPackageUtil.DEFAULT_LOCALE) : null;
                RestActionResult restActionResult = RestActionResult.failure((String)Messages.formatMessage("Could not %s package", command.toString()), (String)Messages.formatMessage("%s of package '%s' is already in progress", StringUtils.capitalize((String)actionBlockerName), packageToProcessPath));
                return restActionResult;
            }
            Job actionJob = this.jobManager.addJob(command.getJobTopic(), PackageActionJobProperties.toMap(packageToProcessPath, packageImportOptions, session.getUserID()));
            if (actionJob == null) {
                LOG.warn("Could not queue package action: {} of package: {}", (Object)command, (Object)packageToProcessPath);
                RestActionResult restActionResult = RestActionResult.failure((String)Messages.formatMessage("Could not %s package", new Object[]{command}), (String)Messages.formatMessage("Could not add %s to job queue", command.getActionTitle().toLowerCase(JcrPackageUtil.DEFAULT_LOCALE)));
                return restActionResult;
            }
            LOG.debug("Successfully queued action: {} of package: {}, Id: {}", new Object[]{command, packageToProcessPath, actionJob.getId()});
            RestActionResult restActionResult = RestActionResult.success((String)Messages.formatMessage("%s queued", command.getActionTitle()), (String)Messages.formatMessage("%s queued for package '%s'", command.getActionTitle(), JcrPackageUtil.getSimplePackageName(packageToProcess)), (Object)((Object)PackageActionStateDto.getState(actionJob.getJobState())));
            return restActionResult;
        }
        catch (OpenPackageException e) {
            LOG.warn("Could not open package: {}", (Object)packageToProcessPath, (Object)e);
            return RestActionResult.failure((String)e.getSimplifiedMessage(), (String)e.getMessage());
        }
    }

    public RestActionResult processAfterPreviousAction(String packageToProcessPath, Session session, PackageActionCommand command, String previousDoneActionMsgText, PackagePrerequisiteValidator ... validators) throws RepositoryException {
        String lowerCaseActionTitle = command.getActionTitle().toLowerCase(JcrPackageUtil.DEFAULT_LOCALE);
        if (StringUtils.isBlank((CharSequence)packageToProcessPath)) {
            LOG.warn("Path was not provided, could not queue {}", (Object)lowerCaseActionTitle);
            return RestActionResult.failure((String)Messages.formatMessage("Package %s, but could not queue %s", previousDoneActionMsgText, lowerCaseActionTitle), (String)Messages.formatMessage("Package %s, but the state was not saved, so '%s' could not be queued", previousDoneActionMsgText, lowerCaseActionTitle), FIRST_ACTION_DONE_FLAG);
        }
        RestActionResult<PackageActionStateDto> actionQueuedResult = this.process(packageToProcessPath, PackageImportOptions.DEFAULT, session, command, validators);
        if (RestActionResult.Status.FAILURE == actionQueuedResult.getStatus()) {
            LOG.warn("Previous action on package was successful, but {} queuing failed", (Object)lowerCaseActionTitle);
            return RestActionResult.failure((String)Messages.formatMessage("Package %s, %s not queued", previousDoneActionMsgText, lowerCaseActionTitle), (String)actionQueuedResult.getMessageDetails(), FIRST_ACTION_DONE_FLAG);
        }
        return RestActionResult.success((String)Messages.formatMessage("Package %s and %s queued", previousDoneActionMsgText, lowerCaseActionTitle), (String)Messages.formatMessage("Package has been %s and %s is queued for package '%s'", previousDoneActionMsgText, lowerCaseActionTitle, packageToProcessPath), (Object)new CombinedActionsDto(packageToProcessPath, PackageActionStateDto.getState(actionQueuedResult.getEntity().toString())));
    }
}

