/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.requestparameters;

import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import pl.ds.websight.packagemanager.packageoptions.PackageImportOptions;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;

public enum PackageActionCommand {
    INSTALL("Installation", "pl/ds/websight/packagemanager/packageaction/install", "Install Package:", "Installing content", "Package installed", (jcrPackage, packageImportOptions, listener, classLoader) -> jcrPackage.install(PackageActionCommand.createImportOptions(listener, classLoader, jcrPackage, packageImportOptions))),
    UNINSTALL("Uninstallation", "pl/ds/websight/packagemanager/packageaction/uninstall", "Uninstall Package:", "Uninstalling content", "Package uninstalled", (jcrPackage, packageImportOptions, listener, classLoader) -> jcrPackage.uninstall(PackageActionCommand.createImportOptions(listener, classLoader, jcrPackage, packageImportOptions))),
    BUILD("Build", "pl/ds/websight/packagemanager/packageaction/build", "Build Package:", "Building package", "Package built", (jcrPackage, listener, manager) -> manager.assemble(jcrPackage, listener)),
    COVERAGE("Coverage", "pl/ds/websight/packagemanager/packageaction/coverage", "Package Coverage Preview:", "Dump package coverage", "Coverage dumped", (jcrPackage, packageImportOptions, listener, classLoader) -> {
        JcrPackageDefinition definition = jcrPackage.getDefinition();
        if (definition != null) {
            definition.dumpCoverage(listener);
        }
    });

    private static final int NODES_MODIFIED_CONCURRENTLY = 1024;
    private final String actionTitle;
    private final String jobTopic;
    private final String logPrefix;
    private final String description;
    private final String logSuffix;
    private CmdPackageExecutor packageExecutor;
    private CmdManagementExecutor managementExecutor;

    private PackageActionCommand(String actionTitle, String jobTopic, String logPrefix, String description, String logSuffix, CmdPackageExecutor packageExecutor) {
        this.actionTitle = actionTitle;
        this.jobTopic = jobTopic;
        this.logPrefix = logPrefix;
        this.description = description;
        this.logSuffix = logSuffix;
        this.packageExecutor = packageExecutor;
    }

    private PackageActionCommand(String actionTitle, String jobTopic, String logPrefix, String description, String logSuffix, CmdManagementExecutor managementExecutor) {
        this.actionTitle = actionTitle;
        this.jobTopic = jobTopic;
        this.logPrefix = logPrefix;
        this.description = description;
        this.logSuffix = logSuffix;
        this.managementExecutor = managementExecutor;
    }

    public String getJobTopic() {
        return this.jobTopic;
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    public String getLogSuffix() {
        return this.logSuffix;
    }

    public String getDescription() {
        return this.description;
    }

    public void executeCommand(JcrPackage jcrPackage, PackageImportOptions packageImportOptions, ProgressTrackerListener listener, ClassLoader classLoader, JcrPackageManager manager) throws RepositoryException, PackageException, IOException {
        if (this.managementExecutor == null) {
            this.packageExecutor.execute(jcrPackage, packageImportOptions, listener, classLoader);
        } else {
            this.managementExecutor.execute(jcrPackage, listener, manager);
        }
    }

    public String getActionTitle() {
        return this.actionTitle;
    }

    public String toString() {
        return this.name().toLowerCase(JcrPackageUtil.DEFAULT_LOCALE);
    }

    public static PackageActionCommand fetchByJobTopic(String jobTopic) {
        return Arrays.stream(PackageActionCommand.values()).filter(command -> command.getJobTopic().equals(jobTopic)).findFirst().orElse(null);
    }

    private static ImportOptions createImportOptions(ProgressTrackerListener listener, ClassLoader classLoader, JcrPackage jcrPackage, PackageImportOptions packageImportOptions) throws RepositoryException {
        ImportOptions options = new ImportOptions();
        options.setAccessControlHandling(Optional.ofNullable(packageImportOptions.getAcHandling()).orElse(jcrPackage.getDefinition().getAccessControlHandling()));
        options.setDependencyHandling(DependencyHandling.REQUIRED);
        options.setAutoSaveThreshold(1024);
        options.setDryRun(packageImportOptions.isDryRun());
        options.setListener(listener);
        options.setHookClassLoader(classLoader);
        options.setNonRecursive(!packageImportOptions.isExtractSubpackages());
        return options;
    }

    private static interface CmdManagementExecutor {
        public void execute(JcrPackage var1, ProgressTrackerListener var2, JcrPackageManager var3) throws RepositoryException, IOException, PackageException;
    }

    private static interface CmdPackageExecutor {
        public void execute(JcrPackage var1, PackageImportOptions var2, ProgressTrackerListener var3, ClassLoader var4) throws RepositoryException, IOException, PackageException;
    }
}

