/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.schedule;

import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.dto.PackageScheduleActionInfoDto;
import pl.ds.websight.packagemanager.dto.ScheduledPackageActionsDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.packageaction.PackageActionRestModel;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class GetScheduledPackageActionsRestAction
extends AbstractRestAction<PackageActionRestModel, ScheduledPackageActionsDto>
implements RestAction<PackageActionRestModel, ScheduledPackageActionsDto> {
    @Reference
    private JobManager jobManager;

    @Override
    protected RestActionResult<ScheduledPackageActionsDto> performAction(PackageActionRestModel model) throws RepositoryException {
        String path;
        Session session = model.getSession();
        if (!session.nodeExists(path = model.getPath())) {
            return RestActionResult.failure((String)"Could not get scheduled package actions", (String)Messages.formatMessage("Could not get package node for path '%s'", path));
        }
        List<PackageScheduleActionInfoDto> scheduledActions = JobUtil.findAllScheduledJobs(this.jobManager, JobProperties.asQueryMap(path)).stream().map(PackageScheduleActionInfoDto::asFullInfo).collect(Collectors.toList());
        return RestActionResult.success((Object)new ScheduledPackageActionsDto(scheduledActions));
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not get scheduled package actions";
    }
}

