/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.PackagePrerequisiteValidator;
import pl.ds.websight.packagemanager.rest.schedule.Schedule;
import pl.ds.websight.packagemanager.rest.schedule.ScheduleActionType;
import pl.ds.websight.packagemanager.rest.schedule.SchedulePackageActionsRestModel;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.OpenPackageException;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction
@Component
public class SchedulePackageActionsRestAction
extends AbstractRestAction<SchedulePackageActionsRestModel, Void>
implements RestAction<SchedulePackageActionsRestModel, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulePackageActionsRestAction.class);
    @Reference
    private JobManager jobManager;
    @Reference
    private Packaging packaging;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RestActionResult<Void> performAction(SchedulePackageActionsRestModel model) throws RepositoryException {
        String path = model.getPath();
        Session session = model.getSession();
        Map<String, Object> packageRefMap = JobProperties.asQueryMap(path);
        try (JcrPackage packageToAddSchedules = JcrPackageUtil.open(path, session, this.packaging.getPackageManager(session));){
            ArrayList<ScheduledJobInfo> updatedScheduledJobs = new ArrayList<ScheduledJobInfo>();
            RestActionResult<Void> updateScheduleJobsResult = this.updateEditedSchedulesJobs(model.getScheduledActionsToUpdate(), path, packageRefMap, updatedScheduledJobs);
            if (updateScheduleJobsResult != null) {
                RestActionResult<Void> restActionResult = updateScheduleJobsResult;
                return restActionResult;
            }
            this.deleteNotUpdatedScheduleJobs(path, packageRefMap, updatedScheduledJobs);
            RestActionResult<Void> addScheduleJobsResult = this.addNewScheduleActions(model.getNewActionsToSchedule(), path, session, packageRefMap, packageToAddSchedules);
            if (addScheduleJobsResult == null) return RestActionResult.success((String)"Actions scheduled", (String)Messages.formatMessage("Actions scheduled for package '%s'", path));
            RestActionResult<Void> restActionResult = addScheduleJobsResult;
            return restActionResult;
        }
        catch (OpenPackageException e) {
            LOG.warn("Could not open package: {}", (Object)path, (Object)e);
            return RestActionResult.failure((String)e.getSimplifiedMessage(), (String)e.getMessage());
        }
    }

    private RestActionResult<Void> updateEditedSchedulesJobs(List<SchedulePackageActionsRestModel.ScheduleAction> actionsToUpdate, String path, Map<String, Object> packageRefMap, List<ScheduledJobInfo> updatedScheduledJobs) {
        for (SchedulePackageActionsRestModel.ScheduleAction actionToUpdate : actionsToUpdate) {
            String scheduleId = actionToUpdate.getScheduleId();
            ScheduledJobInfo scheduledJobToUpdate = JobUtil.findFirstScheduledJob(this.jobManager, packageRefMap, scheduleId);
            if (scheduledJobToUpdate == null) {
                return this.failure("Could not find schedule with id '%s' for package '%s'", scheduleId, path);
            }
            ScheduleActionType scheduleAction = ScheduleActionType.from(scheduledJobToUpdate.getJobTopic());
            if (!actionToUpdate.getActionType().equals((Object)scheduleAction)) {
                return this.failure("Could not change scheduled action type in existed schedule for package '%s'", path);
            }
            String scheduleActionName = ScheduleActionType.getFullName(scheduledJobToUpdate.getJobTopic());
            JobBuilder.ScheduleBuilder scheduleEditBuilder = scheduledJobToUpdate.reschedule();
            if (actionToUpdate.isSuspended()) {
                scheduleEditBuilder.suspend();
            }
            List<Schedule> schedules = actionToUpdate.getSchedules();
            schedules.forEach(schedule -> schedule.addToBuilder(scheduleEditBuilder));
            ArrayList errorMessages = new ArrayList();
            ScheduledJobInfo updatedScheduleJob = scheduleEditBuilder.add(errorMessages);
            if (updatedScheduleJob == null) {
                LOG.warn("Could not reschedule {} for package {} due to: {}", new Object[]{scheduleActionName, path, errorMessages});
                return this.failure("Could not reschedule %s for package '%s' to scheduled jobs queue", scheduleActionName, path);
            }
            if (!actionToUpdate.isSuspended()) {
                updatedScheduleJob.resume();
            }
            updatedScheduledJobs.add(updatedScheduleJob);
            LOG.debug("Successfully rescheduled {} with updated schedules {} for package {}", new Object[]{scheduleActionName, schedules, path});
        }
        return null;
    }

    private void deleteNotUpdatedScheduleJobs(String path, Map<String, Object> queryPropsMap, List<ScheduledJobInfo> updatedScheduledJobs) {
        for (ScheduledJobInfo scheduledJobInfo : JobUtil.findAllScheduledJobs(this.jobManager, queryPropsMap)) {
            if (updatedScheduledJobs.contains(scheduledJobInfo)) continue;
            scheduledJobInfo.unschedule();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Successfully deleted scheduled {} with schedules: {} for package: {}", new Object[]{ScheduleActionType.getFullName(scheduledJobInfo.getJobTopic()).toLowerCase(JcrPackageUtil.DEFAULT_LOCALE), scheduledJobInfo.getSchedules(), path});
        }
    }

    private RestActionResult<Void> addNewScheduleActions(List<SchedulePackageActionsRestModel.ScheduleAction> actionsToAdd, String path, Session session, Map<String, Object> queryPropsMap, JcrPackage packageToAddSchedules) {
        for (SchedulePackageActionsRestModel.ScheduleAction scheduleActionToAdd : actionsToAdd) {
            ScheduleActionType scheduleActionType = scheduleActionToAdd.getActionType();
            Pair<String, String> validationResult = PackagePrerequisiteValidator.getValidationResult(scheduleActionType.getValidators(), packageToAddSchedules, path);
            if (!validationResult.equals((Object)ImmutablePair.nullPair())) {
                return RestActionResult.failure((String)((String)validationResult.getKey()), (String)((String)validationResult.getValue()));
            }
            String jobTopic = scheduleActionType.getJobTopic();
            List<Schedule> schedules = scheduleActionToAdd.getSchedules();
            ScheduledJobInfo alreadyScheduledJob = JobUtil.findScheduledJobWithSchedules(this.jobManager, queryPropsMap, schedules, jobTopic);
            String scheduleActionFullName = scheduleActionType.getFullName();
            if (alreadyScheduledJob != null) {
                return this.failure("%s of package '%s' is already scheduled for this time", StringUtils.capitalize((String)scheduleActionFullName), path);
            }
            JobBuilder.ScheduleBuilder scheduleBuilder = JobUtil.createScheduleBuilder(jobTopic, scheduleActionType.getJobProperties(path, session.getUserID()), this.jobManager);
            schedules.forEach(schedule -> schedule.addToBuilder(scheduleBuilder));
            if (scheduleActionToAdd.isSuspended()) {
                scheduleBuilder.suspend();
            }
            String formattedFullName = scheduleActionFullName.toLowerCase(JcrPackageUtil.DEFAULT_LOCALE);
            if (!JobUtil.addSchedule(scheduleBuilder)) {
                LOG.warn("Could not schedule {} for package: {}", (Object)formattedFullName, (Object)path);
                return this.failure("Could not schedule %s for package '%s'", formattedFullName, path);
            }
            LOG.debug("Scheduled {} of package: {}, used schedules: {}", new Object[]{formattedFullName, path, schedules});
        }
        return null;
    }

    private RestActionResult<Void> failure(String message, Object ... args) {
        return RestActionResult.failure((String)"Could not schedule actions", (String)Messages.formatMessage(message, args));
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not schedule actions";
    }
}

