/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.schedule;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.jcr.Session;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.rest.PackagePathValidatable;
import pl.ds.websight.packagemanager.rest.schedule.OrderedScheduleListDeserializer;
import pl.ds.websight.packagemanager.rest.schedule.Schedule;
import pl.ds.websight.packagemanager.rest.schedule.ScheduleActionType;
import pl.ds.websight.request.parameters.support.annotations.RequestParameter;
import pl.ds.websight.rest.framework.Errors;

@Model(adaptables={SlingHttpServletRequest.class})
public class SchedulePackageActionsRestModel
extends PackagePathValidatable {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulePackageActionsRestModel.class);
    private static final String SCHEDULE_ACTIONS_JOBS_PARAM_NAME = "actions";
    private static final CollectionType LIST_SCHEDULE_ACTION_COLLECTION_TYPE = TypeFactory.defaultInstance().constructCollectionType(List.class, ScheduleAction.class);
    private static final ObjectReader SCHEDULE_ACTIONS_READER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).readerFor((JavaType)LIST_SCHEDULE_ACTION_COLLECTION_TYPE);
    @SlingObject
    private ResourceResolver resourceResolver;
    @RequestParameter
    @NotBlank(message="Path cannot be blank")
    private @NotBlank(message="Path cannot be blank") String path;
    @RequestParameter(name="actions")
    @NotBlank(message="Actions to schedule cannot be blank")
    private @NotBlank(message="Actions to schedule cannot be blank") String actionsJson;
    private List<ScheduleAction> allScheduleActions;
    private List<ScheduleAction> newActionsToSchedule;
    private List<ScheduleAction> scheduledActionsToUpdate;

    @PostConstruct
    private void init() {
        this.allScheduleActions = StringUtils.isNotBlank((CharSequence)this.actionsJson) ? SchedulePackageActionsRestModel.readJson(this.actionsJson) : Collections.emptyList();
        this.newActionsToSchedule = new ArrayList<ScheduleAction>();
        this.scheduledActionsToUpdate = new ArrayList<ScheduleAction>();
        for (ScheduleAction scheduleAction : this.allScheduleActions) {
            if (StringUtils.isNotBlank((CharSequence)scheduleAction.getScheduleId())) {
                this.scheduledActionsToUpdate.add(scheduleAction);
                continue;
            }
            this.newActionsToSchedule.add(scheduleAction);
        }
    }

    private static List<ScheduleAction> readJson(String json) {
        try {
            return (List)SCHEDULE_ACTIONS_READER.readValue(json);
        }
        catch (IOException e) {
            LOG.warn("Could not read jobs to schedule parameter", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    protected String getPath() {
        return this.path;
    }

    public List<ScheduleAction> getNewActionsToSchedule() {
        return this.newActionsToSchedule;
    }

    public List<ScheduleAction> getScheduledActionsToUpdate() {
        return this.scheduledActionsToUpdate;
    }

    public Session getSession() {
        return (Session)this.resourceResolver.adaptTo(Session.class);
    }

    @Override
    public Errors validate() {
        Set<String> duplicatedIds;
        Errors errors = super.validate();
        if (this.hasUnknownScheduleActionType()) {
            errors.add(SCHEDULE_ACTIONS_JOBS_PARAM_NAME, (Object)this.actionsJson, "Schedule actions have to contain only selected operations: " + Arrays.asList(ScheduleActionType.values()).toString());
        }
        this.insertAllSchedulesErrors(errors);
        if (this.containsScheduleDuplicates()) {
            errors.add(SCHEDULE_ACTIONS_JOBS_PARAM_NAME, (Object)this.actionsJson, "Each schedule action cannot contain any schedules duplicates");
        }
        if (!(duplicatedIds = this.getScheduleActionsDuplicatedIds()).isEmpty()) {
            errors.add(SCHEDULE_ACTIONS_JOBS_PARAM_NAME, duplicatedIds, "List contains duplicated schedule actions to update");
        }
        return errors;
    }

    private boolean hasUnknownScheduleActionType() {
        return this.allScheduleActions.stream().map(ScheduleAction::getActionType).anyMatch(Objects::isNull);
    }

    private void insertAllSchedulesErrors(Errors errors) {
        this.allScheduleActions.stream().map(ScheduleAction::getSchedules).flatMap(Collection::stream).map(Schedule::getError).filter(Objects::nonNull).distinct().forEach(errorPair -> errors.add(SCHEDULE_ACTIONS_JOBS_PARAM_NAME, errorPair.getKey(), (String)errorPair.getValue()));
    }

    private boolean containsScheduleDuplicates() {
        return this.newActionsToSchedule.stream().map(ScheduleAction::getSchedules).anyMatch(schedules -> schedules.stream().distinct().count() != (long)schedules.size());
    }

    private Set<String> getScheduleActionsDuplicatedIds() {
        List ids = this.scheduledActionsToUpdate.stream().map(scheduledJobToUpdate -> ((ScheduleAction)scheduledJobToUpdate).scheduleId).collect(Collectors.toList());
        return ids.stream().filter(id -> Collections.frequency(ids, id) > 1).collect(Collectors.toSet());
    }

    public static class ScheduleAction {
        @JsonProperty(value="id")
        private String scheduleId;
        @JsonProperty(value="action")
        private ScheduleActionType actionType;
        private boolean suspended;
        @JsonDeserialize(using=OrderedScheduleListDeserializer.class)
        private List<Schedule> schedules;

        public String getScheduleId() {
            return this.scheduleId;
        }

        public ScheduleActionType getActionType() {
            return this.actionType;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public List<Schedule> getSchedules() {
            return this.schedules;
        }
    }
}

