/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.util;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;

public final class JcrPackageStatusUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JcrPackageStatusUtil.class);

    private JcrPackageStatusUtil() {
    }

    public static boolean isInstalled(JcrPackage jcrPackage) {
        return JcrPackageStatusUtil.isBuilt(jcrPackage) && (JcrPackageStatusUtil.hasSnapshot(jcrPackage) || JcrPackageUtil.fetchDefinition(jcrPackage).map(packageDefinition -> JcrPackageStatusUtil.isNewer(packageDefinition.getLastUnpacked(), packageDefinition.getLastUnwrapped(), 1L)).orElse(false) != false);
    }

    private static boolean hasSnapshot(JcrPackage jcrPackage) {
        try {
            return jcrPackage.getSnapshot() != null;
        }
        catch (RepositoryException e) {
            LOG.warn("Could not check whether the package has local snapshot", (Throwable)e);
            return false;
        }
    }

    public static boolean isModified(JcrPackage jcrPackage) {
        return JcrPackageStatusUtil.isBuilt(jcrPackage) && JcrPackageUtil.fetchDefinition(jcrPackage).map(packageDefinition -> JcrPackageStatusUtil.wasModifiedAfterCreation(packageDefinition) && JcrPackageStatusUtil.notUnwrappedAfterModification(packageDefinition)).orElse(false) != false;
    }

    public static boolean isBuilt(JcrPackage jcrPackage) {
        return jcrPackage.getSize() > 0L || JcrPackageStatusUtil.hasBuilds(jcrPackage);
    }

    private static boolean hasBuilds(JcrPackage jcrPackage) {
        return JcrPackageUtil.fetchDefinition(jcrPackage).map(jcrPackageDefinition -> jcrPackageDefinition.getBuildCount() > 0L).orElse(false);
    }

    private static boolean wasModifiedAfterCreation(JcrPackageDefinition jcrPackageDefinition) {
        return JcrPackageStatusUtil.isNewer(jcrPackageDefinition.getLastModified(), jcrPackageDefinition.getCreated(), 1000L);
    }

    private static boolean notUnwrappedAfterModification(JcrPackageDefinition jcrPackageDefinition) {
        return !JcrPackageStatusUtil.isNewer(jcrPackageDefinition.getLastUnwrapped(), jcrPackageDefinition.getLastModified(), 1L);
    }

    private static boolean isNewer(Calendar firstDate, Calendar secondDate, long tolerance) {
        long secondDateInMillis = secondDate != null ? secondDate.getTimeInMillis() : 0L;
        return firstDate != null && firstDate.getTimeInMillis() - secondDateInMillis >= tolerance;
    }

    public static boolean hasUnresolvedDependencies(JcrPackage jcrPackage) {
        try {
            return jcrPackage.getUnresolvedDependencies().length == 0;
        }
        catch (RepositoryException e) {
            LOG.warn("Could not check unresolved dependencies", (Throwable)e);
            return false;
        }
    }
}

