/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.sling.event.jobs.Job;

public enum PackageActionStateDto {
    QUEUED(arg_0 -> Job.JobState.QUEUED.equals(arg_0)),
    RUNNING(arg_0 -> Job.JobState.ACTIVE.equals(arg_0)),
    FINISHED(jobState -> !Job.JobState.QUEUED.equals(jobState) && !Job.JobState.ACTIVE.equals(jobState)),
    UNKNOWN(jobState -> false);

    private final Predicate<Job.JobState> valueByJobStatePredicate;

    private PackageActionStateDto(Predicate<Job.JobState> valueByJobStatePredicate) {
        this.valueByJobStatePredicate = valueByJobStatePredicate;
    }

    public static PackageActionStateDto getState(Job.JobState jobState) {
        return PackageActionStateDto.getState((PackageActionStateDto actionStateDto) -> actionStateDto.valueByJobStatePredicate.test(jobState));
    }

    public static PackageActionStateDto getState(String name) {
        return PackageActionStateDto.getState((PackageActionStateDto actionStateDto) -> actionStateDto.toString().equalsIgnoreCase(name));
    }

    private static PackageActionStateDto getState(Predicate<PackageActionStateDto> matchPredicate) {
        return Arrays.stream(PackageActionStateDto.values()).filter(matchPredicate).findFirst().orElse(UNKNOWN);
    }
}

