/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.dto.PackageActionDto;
import pl.ds.websight.packagemanager.dto.PackageActionInfoDto;
import pl.ds.websight.packagemanager.dto.PackageDependencyDto;
import pl.ds.websight.packagemanager.dto.PackageFilterDto;
import pl.ds.websight.packagemanager.dto.PackageScheduleActionInfoDto;
import pl.ds.websight.packagemanager.dto.PackageStatusDto;
import pl.ds.websight.packagemanager.dto.PackageThumbnailDto;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;

public class PackageDto {
    private static final Logger LOG = LoggerFactory.getLogger(PackageDto.class);
    private String path;
    private String parentPath;
    private String description;
    private PackageActionInfoDto modification;
    private PackageActionInfoDto unwrap;
    private PackageActionInfoDto wrap;
    private long buildCount;
    private long size;
    private PackageId packageInfo;
    private final boolean isJcrPackageValid;
    private boolean requiresRestart;
    private long timestamp;
    private PackageThumbnailDto thumbnail;
    private PackageStatusDto status;
    private List<PackageFilterDto> filters;
    private PackageActionDto lastAction;
    private String acHandling;
    private List<PackageDependencyDto> dependencies;
    private PackageScheduleActionInfoDto nextScheduledAction;

    private PackageDto() {
        this.isJcrPackageValid = false;
    }

    private PackageDto(JcrPackage jcrPackage) throws RepositoryException {
        JcrPackageDefinition packageDefinition = jcrPackage.getDefinition();
        this.packageInfo = packageDefinition != null ? packageDefinition.getId() : null;
        this.description = packageDefinition != null ? packageDefinition.getDescription() : null;
        this.buildCount = packageDefinition != null ? packageDefinition.getBuildCount() : 0L;
        this.modification = PackageActionInfoDto.create(packageDefinition, "jcr:lastModified");
        this.unwrap = PackageActionInfoDto.create(packageDefinition, "lastUnwrapped");
        this.wrap = PackageActionInfoDto.create(packageDefinition, "lastWrapped");
        this.isJcrPackageValid = jcrPackage.isValid();
        this.size = jcrPackage.getSize();
        this.requiresRestart = packageDefinition != null && packageDefinition.requiresRestart();
        this.status = PackageStatusDto.fetchPackageStatus(jcrPackage);
        this.path = "";
        this.acHandling = packageDefinition != null ? PackageDto.parseAcHandling(packageDefinition.getAccessControlHandling()) : null;
        this.dependencies = PackageDto.parsePackageDependencies(jcrPackage);
    }

    private static String parseAcHandling(AccessControlHandling acHandling) {
        if (acHandling == null) {
            return null;
        }
        String acHandlingString = StringUtils.lowerCase((String)acHandling.toString());
        String[] parts = acHandlingString.split("_");
        String formattedAcHandling = StringUtils.capitalize((String)parts[0]);
        if (parts.length > 1) {
            formattedAcHandling = formattedAcHandling + StringUtils.capitalize((String)parts[1]);
        }
        return formattedAcHandling;
    }

    private static List<PackageDependencyDto> parsePackageDependencies(JcrPackage jcrPackage) throws RepositoryException {
        Dependency[] unresolvedDependencies;
        JcrPackageDefinition packageDefinition = jcrPackage.getDefinition();
        if (packageDefinition == null) {
            return Collections.emptyList();
        }
        Dependency[] allDependencies = packageDefinition.getDependencies();
        try {
            unresolvedDependencies = jcrPackage.getUnresolvedDependencies();
        }
        catch (RepositoryException e) {
            LOG.warn("Could not get unresolved dependencies from package", (Throwable)e);
            unresolvedDependencies = allDependencies;
        }
        Dependency[] packageUnresolvedDependencies = unresolvedDependencies;
        return allDependencies.length != 0 ? Arrays.stream(allDependencies).map(dependency -> new PackageDependencyDto(dependency.toString(), !ArrayUtils.contains((Object[])packageUnresolvedDependencies, (Object)dependency))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String getPath() {
        return this.path;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getDescription() {
        return this.description;
    }

    public PackageActionInfoDto getModification() {
        return this.modification;
    }

    public PackageActionInfoDto getUnwrap() {
        return this.unwrap;
    }

    public PackageActionInfoDto getWrap() {
        return this.wrap;
    }

    public long getBuildCount() {
        return this.buildCount;
    }

    public long getSize() {
        return this.size;
    }

    public PackageId getPackageInfo() {
        return this.packageInfo;
    }

    public boolean isJcrPackageValid() {
        return this.isJcrPackageValid;
    }

    public boolean isRequiresRestart() {
        return this.requiresRestart;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PackageThumbnailDto getThumbnail() {
        return this.thumbnail;
    }

    public PackageStatusDto getStatus() {
        return this.status;
    }

    public List<PackageFilterDto> getFilters() {
        return this.filters;
    }

    public PackageActionDto getLastAction() {
        return this.lastAction;
    }

    public String getAcHandling() {
        return this.acHandling;
    }

    public List<PackageDependencyDto> getDependencies() {
        return this.dependencies;
    }

    public PackageScheduleActionInfoDto getNextScheduledAction() {
        return this.nextScheduledAction;
    }

    public void setLastAction(PackageActionDto lastAction) {
        this.lastAction = lastAction;
    }

    public void setNextScheduledAction(PackageScheduleActionInfoDto nextScheduledAction) {
        this.nextScheduledAction = nextScheduledAction;
    }

    public static PackageDto wrap(JcrPackage jcrPackage, Session session, JobManager jobManager) {
        PackageDto packageDto = PackageDto.initPackageDto(jcrPackage, session);
        if (packageDto == null) {
            LOG.debug("Passed invalid package to output, creating placeholder");
            return PackageDto.createInvalidPackage(jcrPackage.getNode());
        }
        packageDto.lastAction = PackageActionDto.forPackagePath(jobManager, session, packageDto.path);
        packageDto.nextScheduledAction = PackageDto.fetchNearestScheduledAction(jobManager, packageDto.path);
        return packageDto;
    }

    public static PackageDto wrapWithoutJobsData(JcrPackage jcrPackage, Session session) {
        PackageDto packageDto = PackageDto.initPackageDto(jcrPackage, session);
        if (packageDto == null) {
            LOG.debug("Passed invalid package to output, creating placeholder");
            return PackageDto.createInvalidPackage(jcrPackage.getNode());
        }
        return packageDto;
    }

    private static PackageDto initPackageDto(JcrPackage jcrPackage, Session session) {
        try {
            PackageDto packageDto = new PackageDto(jcrPackage);
            Node packageNode = jcrPackage.getNode();
            if (packageNode != null) {
                packageDto.path = packageNode.getPath();
                packageDto.parentPath = packageNode.getParent().getPath();
                if (JcrPackageUtil.hasValidFilters(session, packageDto.path)) {
                    packageDto.filters = PackageDto.fetchPackageFilters(packageDto.path, session);
                }
                packageDto.timestamp = PackageDto.fetchPackageModificationTimestamp(jcrPackage);
                packageDto.thumbnail = PackageThumbnailDto.forPackagePath(packageDto.path, session);
                return packageDto;
            }
        }
        catch (RepositoryException e) {
            LOG.warn("Could not assign particular properties from JCR Package to Package DTO", (Throwable)e);
        }
        return null;
    }

    private static List<PackageFilterDto> fetchPackageFilters(String packageNodePath, Session session) throws RepositoryException {
        String filterRootPath = packageNodePath + "/jcr:content/vlt:definition/filter";
        NodeIterator filterNodes = session.getNode(filterRootPath).getNodes();
        ArrayList<PackageFilterDto> packageFilters = new ArrayList<PackageFilterDto>();
        while (filterNodes.hasNext()) {
            PackageFilterDto packageFilter = PackageFilterDto.create(filterNodes.nextNode());
            if (packageFilter == null) continue;
            packageFilters.add(packageFilter);
        }
        return packageFilters;
    }

    private static PackageScheduleActionInfoDto fetchNearestScheduledAction(JobManager jobManager, String packagePath) {
        ScheduledJobInfo nearestScheduledJobInfo = JobUtil.getNearestScheduledJob(jobManager, packagePath);
        if (nearestScheduledJobInfo != null) {
            return PackageScheduleActionInfoDto.asBasicInfo(nearestScheduledJobInfo);
        }
        return null;
    }

    private static long fetchPackageModificationTimestamp(JcrPackage jcrPackage) throws RepositoryException {
        Node packageContentNode;
        long packageModificationTimestamp = JcrPackageUtil.fetchDefinition(jcrPackage).map(JcrPackageDefinition::getLastModified).map(Calendar::getTimeInMillis).orElse(0L);
        if (packageModificationTimestamp != 0L) {
            return packageModificationTimestamp;
        }
        Node packageNode = jcrPackage.getNode();
        if (packageNode == null) {
            return packageModificationTimestamp;
        }
        if (packageNode.hasNode("jcr:content") && (packageContentNode = packageNode.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
            LOG.warn("Could not get last modification date of package definition for: {}, using package content modification date", (Object)packageNode.getPath());
            return packageContentNode.getProperty("jcr:lastModified").getDate().getTimeInMillis();
        }
        LOG.warn("Could not get last modification date of package definition for: {}, using package upload date", (Object)packageNode.getPath());
        return packageNode.hasProperty("jcr:created") ? packageNode.getProperty("jcr:created").getDate().getTimeInMillis() : packageModificationTimestamp;
    }

    private static PackageDto createInvalidPackage(Node invalidPackageNode) {
        PackageDto invalidPackage = new PackageDto();
        try {
            invalidPackage.path = invalidPackageNode != null ? invalidPackageNode.getPath() : "Unresolvable path";
        }
        catch (RepositoryException e) {
            invalidPackage.path = "Unresolvable path";
        }
        return invalidPackage;
    }
}

