/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;

public class PackageFilterDto {
    private static final Logger LOG = LoggerFactory.getLogger(PackageFilterDto.class);
    private final String root;
    private final ImportMode mode;
    private final List<PackageFilterRuleDto> rules;

    private PackageFilterDto(String root, ImportMode mode, List<PackageFilterRuleDto> rules) {
        this.root = root;
        this.mode = mode;
        this.rules = rules;
    }

    public static PackageFilterDto create(Node filterNode) {
        try {
            return new PackageFilterDto(filterNode.getProperty("root").getString(), PackageFilterDto.getImportMode(filterNode), PackageFilterDto.getFilterRules(filterNode));
        }
        catch (RepositoryException e) {
            LOG.warn("Could not fetch Package Filters from node properties", (Throwable)e);
            return null;
        }
    }

    private static ImportMode getImportMode(Node filterNode) throws RepositoryException {
        Property modeProp = filterNode.getProperty("mode");
        return modeProp != null ? JcrPackageUtil.toImportMode(modeProp.getString()) : ImportMode.REPLACE;
    }

    private static List<PackageFilterRuleDto> getFilterRules(Node filterNode) throws RepositoryException {
        Value[] valueArray;
        Property rulesProp = filterNode.getProperty("rules");
        if (rulesProp.isMultiple()) {
            valueArray = rulesProp.getValues();
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = rulesProp.getValue();
        }
        Value[] ruleValues = valueArray;
        return Arrays.stream(ruleValues).map(x$0 -> PackageFilterRuleDto.create(x$0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getRoot() {
        return this.root;
    }

    public ImportMode getMode() {
        return this.mode;
    }

    public List<PackageFilterRuleDto> getRules() {
        return this.rules;
    }

    private static class PackageFilterRuleDto {
        private static final String MODIFIER_PATTERN_SEPARATOR = ":";
        private final boolean include;
        private final String pattern;

        private PackageFilterRuleDto(String rule) {
            this.include = "include".equals(PackageFilterRuleDto.extractIncludeInfo(rule));
            this.pattern = PackageFilterRuleDto.extractPattern(rule);
        }

        private static PackageFilterRuleDto create(Value ruleValue) {
            String rule = PackageFilterRuleDto.getRuleText(ruleValue);
            if (PackageFilterRuleDto.isValid(rule)) {
                return new PackageFilterRuleDto(rule);
            }
            LOG.warn("Rule: {} is malformed and will be skipped during processing", (Object)rule);
            return null;
        }

        private static String getRuleText(Value ruleValue) {
            try {
                return ruleValue.getString();
            }
            catch (RepositoryException e) {
                LOG.warn("Could not get Filter rule as text", (Throwable)e);
                return null;
            }
        }

        private static boolean isValid(String rule) {
            return StringUtils.contains((CharSequence)rule, (CharSequence)MODIFIER_PATTERN_SEPARATOR) && PackageFilterRuleDto.extractPattern(rule).length() > 0 && StringUtils.containsAny((CharSequence)PackageFilterRuleDto.extractIncludeInfo(rule), (CharSequence[])new CharSequence[]{"include", "exclude"});
        }

        private static String extractPattern(String rule) {
            return StringUtils.substringAfter((String)rule, (String)MODIFIER_PATTERN_SEPARATOR);
        }

        private static String extractIncludeInfo(String rule) {
            return StringUtils.substringBefore((String)rule, (String)MODIFIER_PATTERN_SEPARATOR);
        }

        public boolean isInclude() {
            return this.include;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

