/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JcrPackageEditFacade;
import pl.ds.websight.packagemanager.dto.PackageDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.PackagePathSaveHelper;
import pl.ds.websight.packagemanager.rest.PackageRestModel;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;

public abstract class AbstractCreatableRestAction
extends AbstractRestAction<PackageRestModel, PackageDto>
implements RestAction<PackageRestModel, PackageDto> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCreatableRestAction.class);
    protected Packaging packaging;
    protected JobManager jobManager;

    protected abstract void setPackaging(Packaging var1);

    protected abstract void setJobManager(JobManager var1);

    protected RestActionResult<PackageDto> performCreation(PackageRestModel model) throws IOException, RepositoryException {
        return this.performCreation(model, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RestActionResult<PackageDto> performCreation(PackageRestModel model, PackagePathSaveHelper pathSaveHelper) throws IOException, RepositoryException {
        Session session = model.getSession();
        JcrPackageManager packageManager = this.packaging.getPackageManager(session);
        String packageName = model.getName();
        String packageVersion = model.getVersion();
        try (JcrPackage createdPackage = packageManager.create(model.getGroup(), packageName, packageVersion);){
            JcrPackageEditFacade editFacade = JcrPackageEditFacade.forPackage(createdPackage);
            if (editFacade == null) {
                LOG.warn("Could not access definition after creating a package: {}", (Object)JcrPackageUtil.getSimplePackageName(packageName, packageVersion));
                RestActionResult restActionResult2 = RestActionResult.failure((String)"Package created partially", (String)Messages.formatMessage("Package '%s' has been created, but could not save details", packageName), (Object)PackageDto.wrap(createdPackage, session, this.jobManager));
                return restActionResult2;
            }
            editFacade.setFilters(model.getFilters());
            String description = model.getDescription();
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                editFacade.setDescription(description);
            }
            editFacade.setAcHandling(model.getAcHandling());
            editFacade.setRequiresRestart(model.requiresRestart());
            editFacade.setDependencies(model.getDependencies());
            if (model.getThumbnail() != null) {
                try (InputStream thumbnailStream = model.getThumbnail().getInputStream();){
                    editFacade.setThumbnail(thumbnailStream, model.getResourceResolver());
                }
            }
            session.save();
            if (pathSaveHelper != null) {
                pathSaveHelper.setPathRequestAttribute(createdPackage.getNode());
            }
            RestActionResult restActionResult = RestActionResult.success((String)"Package created", (String)Messages.formatMessage("Package '%s' has been created", packageName), (Object)PackageDto.wrap(createdPackage, session, this.jobManager));
            return restActionResult;
        }
        catch (ItemExistsException e) {
            LOG.warn("Package already exists", (Throwable)e);
            return RestActionResult.failure((String)"Package already exists", (String)Messages.formatMessage("Package '%s' already exists", packageName));
        }
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not create package";
    }
}

