/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.dto.PackageDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.EditPackageRestModel;
import pl.ds.websight.packagemanager.rest.PackagePathSaveHelper;
import pl.ds.websight.packagemanager.rest.schedule.Schedule;
import pl.ds.websight.packagemanager.rest.schedule.ScheduleActionType;
import pl.ds.websight.packagemanager.util.DateUtil;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.PackageLogUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;

public abstract class AbstractEditableRestAction
extends AbstractRestAction<EditPackageRestModel, PackageDto>
implements RestAction<EditPackageRestModel, PackageDto> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEditableRestAction.class);
    protected Packaging packaging;
    protected JobManager jobManager;

    protected abstract void setPackaging(Packaging var1);

    protected abstract void setJobManager(JobManager var1);

    protected RestActionResult<PackageDto> performEdit(EditPackageRestModel model) throws IOException, RepositoryException {
        return this.performEdit(model, null);
    }

    /*
     * Exception decompiling
     */
    protected RestActionResult<PackageDto> performEdit(EditPackageRestModel model, PackagePathSaveHelper pathSaveHelper) throws RepositoryException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean hasPackageIdChanged(JcrPackage jcrPackage, String newName, String newGroup, String newVersion) {
        return JcrPackageUtil.fetchDefinition(jcrPackage).map(JcrPackageDefinition::getId).map(packageId -> !packageId.getName().equals(newName) || !packageId.getGroup().equals(newGroup) || !packageId.getVersionString().equals(newVersion)).orElse(false);
    }

    private static void movePackageLogs(JcrPackage packageRenamed, String oldPackagePath, Session session) throws RepositoryException {
        Node renamedPackageNode;
        String oldLogPath = PackageLogUtil.getLogPath(oldPackagePath);
        if (session.nodeExists(oldLogPath) && (renamedPackageNode = packageRenamed.getNode()) != null) {
            String logPath = PackageLogUtil.getLogPath(renamedPackageNode.getPath());
            if (AbstractEditableRestAction.anyIntermediateLogNodeNotExist(logPath, session)) {
                AbstractEditableRestAction.createAllIntermediateLogNodes(logPath, session);
            } else if (session.nodeExists(logPath)) {
                session.removeItem(logPath);
                session.save();
            }
            session.move(oldLogPath, logPath);
            session.save();
        }
    }

    private static boolean anyIntermediateLogNodeNotExist(String absLogPath, Session session) throws RepositoryException {
        String logPathWithoutPackageNode = absLogPath.substring(0, absLogPath.lastIndexOf(47));
        return !session.nodeExists(logPathWithoutPackageNode);
    }

    private static void createAllIntermediateLogNodes(String absLogPath, Session session) throws RepositoryException {
        String relLogPath = AbstractEditableRestAction.absoluteToRelativeNodePath(absLogPath);
        if (!relLogPath.contains("/")) {
            return;
        }
        String[] subNodeNames = AbstractEditableRestAction.splitToIntermediateNodeNames(relLogPath);
        Node node = session.getNode("/var/websight/websight-package-manager-service/logs/");
        for (String subNodeName : subNodeNames) {
            if (node.hasNode(subNodeName)) {
                node = node.getNode(subNodeName);
                continue;
            }
            node = node.addNode(subNodeName);
            node.setProperty("sling:resourceType", "sling:Folder");
        }
        session.save();
    }

    private static String absoluteToRelativeNodePath(String absLogPath) {
        return StringUtils.removeStart((String)absLogPath, (String)"/var/websight/websight-package-manager-service/logs/");
    }

    private static String[] splitToIntermediateNodeNames(String relLogPath) {
        Object[] subNodeNames = relLogPath.split("/");
        return (String[])ArrayUtils.remove((Object[])subNodeNames, (int)(subNodeNames.length - 1));
    }

    private static boolean updatePackageActionsSchedules(JcrPackage packageRenamed, String oldPackagePath, JobManager jobManager) throws RepositoryException {
        Node renamedPackageNode = packageRenamed.getNode();
        if (renamedPackageNode == null) {
            LOG.warn("Could not access renamed package node, so update of scheduled jobs will be skipped");
            return true;
        }
        String newPackagePath = renamedPackageNode.getPath();
        for (ScheduledJobInfo scheduledJobToUpdate : JobUtil.findAllScheduledJobs(jobManager, JobProperties.asQueryMap(oldPackagePath))) {
            ScheduleActionType scheduleActionType = ScheduleActionType.from(scheduledJobToUpdate.getJobTopic());
            if (scheduleActionType == null) {
                LOG.warn("Could not update scheduled unknown action for package: {}", (Object)newPackagePath);
                return false;
            }
            String scheduleActionName = scheduleActionType.getFullName().toLowerCase(JcrPackageUtil.DEFAULT_LOCALE);
            String applicantId = JobProperties.getApplicantId(scheduledJobToUpdate);
            if (applicantId == null) {
                LOG.warn("Could not update scheduled {} for package: {} due to lack of info about applicant Id", (Object)scheduleActionName, (Object)oldPackagePath);
                return false;
            }
            JobBuilder.ScheduleBuilder updatedScheduleBuilder = JobUtil.createScheduleBuilder(scheduledJobToUpdate.getJobTopic(), scheduleActionType.getJobProperties(newPackagePath, applicantId), jobManager);
            if (scheduledJobToUpdate.isSuspended()) {
                updatedScheduleBuilder.suspend();
            }
            for (ScheduleInfo scheduleInfo : scheduledJobToUpdate.getSchedules()) {
                Schedule schedule = Schedule.createSchedule(DateUtil.format(scheduleInfo.getAt()), scheduleInfo.getExpression());
                if (schedule.getError() != null) {
                    LOG.warn("Could not update one of schedules of scheduled {} for package: {}", (Object)scheduleActionName, (Object)newPackagePath);
                    return false;
                }
                schedule.addToBuilder(updatedScheduleBuilder);
            }
            scheduledJobToUpdate.unschedule();
            LOG.debug("Successfully unscheduled {} with deprecated package path: {} instead of new one: {}", new Object[]{scheduleActionName, oldPackagePath, newPackagePath});
            if (JobUtil.addSchedule(updatedScheduleBuilder)) continue;
            LOG.warn("Could not schedule {} for package {}", (Object)scheduleActionName, (Object)newPackagePath);
            return false;
        }
        return true;
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not edit package";
    }
}

