/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;

public abstract class AbstractRestAction<T, R>
implements RestAction<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRestAction.class);

    public RestActionResult<R> perform(T model) {
        try {
            return this.performAction(model);
        }
        catch (Exception e) {
            LOG.warn("Could not perform action", (Throwable)e);
            String messageDetails = e.getClass().getSimpleName();
            String exceptionMessage = e.getMessage();
            if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                messageDetails = messageDetails + ": " + exceptionMessage;
            }
            return RestActionResult.failure((String)this.getUnexpectedErrorMessage(), (String)messageDetails);
        }
    }

    protected abstract RestActionResult<R> performAction(T var1) throws RepositoryException, IOException;

    protected abstract String getUnexpectedErrorMessage();
}

