/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackagePathSaveHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PackagePathSaveHelper.class);
    private static final String PATH_ATTR_NAME_SUFFIX = ".savedPackagePath";
    private final SlingHttpServletRequest request;
    private final String pathAttrName;

    public PackagePathSaveHelper(SlingHttpServletRequest request, Class<?> applicantClass) {
        this.request = request;
        this.pathAttrName = applicantClass.getName() + PATH_ATTR_NAME_SUFFIX;
    }

    public void setPathRequestAttribute(Node packageNode) {
        try {
            String packagePath;
            String string = packagePath = packageNode != null ? packageNode.getPath() : null;
            if (StringUtils.isNotBlank((CharSequence)packagePath)) {
                RequestUtil.setRequestAttribute((HttpServletRequest)this.request, (String)this.pathAttrName, (Object)packagePath);
            }
        }
        catch (RepositoryException e) {
            LOG.warn("Could not save path in request attribute", (Throwable)e);
        }
    }

    public String getPathRequestAttribute() {
        Object pathAttr = this.request.getAttribute(this.pathAttrName);
        return pathAttr != null ? pathAttr.toString() : null;
    }
}

