/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobProperties;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.rest.packageaction.PackageActionRestModel;
import pl.ds.websight.packagemanager.rest.requestparameters.PackageActionCommand;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction
@Component
public class CancelPackageActionRestAction
extends AbstractRestAction<PackageActionRestModel, Void>
implements RestAction<PackageActionRestModel, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CancelPackageActionRestAction.class);
    @Reference
    private JobManager jobManager;

    @Override
    protected RestActionResult<Void> performAction(PackageActionRestModel model) {
        String packagePath = model.getPath();
        List<Job> allQueuedJobs = JobUtil.findAllQueuedJobs(this.jobManager, PackageActionJobProperties.asQueryMap(packagePath));
        if (allQueuedJobs.isEmpty()) {
            LOG.warn("Could not cancel jobs for package {} due to lack of queued actions", (Object)packagePath);
            return RestActionResult.failure((String)"There are no queued actions", (String)Messages.formatMessage("There are no queued actions for package '%s'", packagePath));
        }
        Job lastQueuedJob = null;
        Iterator<Job> iterator = allQueuedJobs.iterator();
        while (iterator.hasNext()) {
            Job queuedJob;
            lastQueuedJob = queuedJob = iterator.next();
            String jobId = queuedJob.getId();
            LOG.debug("Trying to delete a job for package {} with jobId {} and topic {}", new Object[]{packagePath, jobId, queuedJob.getTopic()});
            if (this.jobManager.removeJobById(jobId)) continue;
            LOG.warn("Could not delete a job for package {} with jobId {} and topic {}", new Object[]{packagePath, jobId, queuedJob.getTopic()});
            String formattedActionTitle = CancelPackageActionRestAction.getFormattedActionTitle(queuedJob);
            return RestActionResult.failure((String)Messages.formatMessage("Could not cancel queued %s", formattedActionTitle.toLowerCase(JcrPackageUtil.DEFAULT_LOCALE)), (String)Messages.formatMessage("Could not cancel queued %s for package '%s'", formattedActionTitle.toLowerCase(JcrPackageUtil.DEFAULT_LOCALE), packagePath));
        }
        String formattedLastActionTitle = CancelPackageActionRestAction.getFormattedActionTitle(lastQueuedJob);
        return RestActionResult.success((String)Messages.formatMessage("%s cancelled", formattedLastActionTitle, packagePath), (String)Messages.formatMessage("Cancelled %s and other queued actions for package '%s'", formattedLastActionTitle.toLowerCase(JcrPackageUtil.DEFAULT_LOCALE), packagePath));
    }

    private static String getFormattedActionTitle(Job job) {
        PackageActionCommand packageActionCommand;
        if (job != null && (packageActionCommand = PackageActionCommand.fetchByJobTopic(job.getTopic())) != null) {
            return packageActionCommand.getActionTitle();
        }
        return "'unknown action'";
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not cancel package action";
    }
}

