/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import pl.ds.websight.packagemanager.dto.PackageActionDto;
import pl.ds.websight.packagemanager.dto.PackageActionReportDto;
import pl.ds.websight.packagemanager.dto.PackageActionStateDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.packageaction.GetPackageActionReportRestModel;
import pl.ds.websight.packagemanager.util.PackageLogUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class GetPackageActionReportRestAction
extends AbstractRestAction<GetPackageActionReportRestModel, PackageActionReportDto>
implements RestAction<GetPackageActionReportRestModel, PackageActionReportDto> {
    @Reference
    private JobManager jobManager;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Override
    protected RestActionResult<PackageActionReportDto> performAction(GetPackageActionReportRestModel model) throws RepositoryException {
        String packagePath = model.getPath();
        Session session = model.getSession();
        String logPath = PackageLogUtil.getLogPath(packagePath);
        PackageActionDto action = PackageActionDto.forPackagePath(this.jobManager, session, packagePath);
        PackageActionStateDto actionState = action.getState();
        if (PackageActionStateDto.UNKNOWN.equals((Object)actionState)) {
            return !session.nodeExists(packagePath) || !session.nodeExists(logPath) ? RestActionResult.failure((String)"Could not get or access package action logs", (String)"An error occurred while fetching logs") : RestActionResult.success((Object)new PackageActionReportDto(action));
        }
        Node logNode = session.getNode(logPath);
        return RestActionResult.success((Object)new PackageActionReportDto(action, PackageLogUtil.getLog(logNode, false)));
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not get or access package action logs";
    }
}

