/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.requestparameters;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.util.JcrPackageStatusUtil;
import pl.ds.websight.packagemanager.util.JobUtil;

public enum FilterOption {
    CREATED_BY_ME("createdByMe", (jcrPackage, userId, jobManager) -> FilterOption.isPackageCreator(jcrPackage, userId)),
    BUILT("built", (jcrPackage, userId, jobManager) -> JcrPackageStatusUtil.isBuilt(jcrPackage)),
    NOT_BUILT("notBuilt", (jcrPackage, userId, jobManager) -> !JcrPackageStatusUtil.isBuilt(jcrPackage)),
    INSTALLED("installed", (jcrPackage, userId, jobManager) -> JcrPackageStatusUtil.isInstalled(jcrPackage)),
    NOT_INSTALLED("notInstalled", (jcrPackage, userId, jobManager) -> !JcrPackageStatusUtil.isInstalled(jcrPackage)),
    MODIFIED("modified", (jcrPackage, userId, jobManager) -> JcrPackageStatusUtil.isModified(jcrPackage)),
    SCHEDULED("scheduled", (jcrPackage, userId, jobManager) -> FilterOption.containsAnySchedule(jcrPackage, jobManager));

    private static final Logger LOG;
    private final String paramName;
    private final PackageFilter filter;

    private FilterOption(String paramName, PackageFilter filter) {
        this.paramName = paramName;
        this.filter = filter;
    }

    private static boolean isPackageCreator(JcrPackage jcrPackage, String userId) {
        try {
            Node packageNode = jcrPackage.getNode();
            if (packageNode != null) {
                Property createdByVal = packageNode.getProperty("jcr:createdBy");
                String createdBy = createdByVal.getString();
                return StringUtils.equals((CharSequence)userId, (CharSequence)createdBy);
            }
        }
        catch (RepositoryException e) {
            LOG.warn(String.format("Could not check if user with id: %s was a creator of package", userId), (Throwable)e);
        }
        return false;
    }

    private static boolean containsAnySchedule(JcrPackage jcrPackage, JobManager jobManager) {
        Node packageNode = jcrPackage.getNode();
        try {
            String path = packageNode != null ? packageNode.getPath() : null;
            return path != null && !JobUtil.findAllScheduledJobs(jobManager, JobProperties.asQueryMap(path)).isEmpty();
        }
        catch (RepositoryException e) {
            LOG.warn("Could not check if package contains any schedules", (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return this.paramName;
    }

    public boolean matches(JcrPackage jcrPackage, String userId, JobManager jobManager) {
        return this.filter.test(jcrPackage, userId, jobManager);
    }

    static {
        LOG = LoggerFactory.getLogger(FilterOption.class);
    }

    private static interface PackageFilter {
        public boolean test(JcrPackage var1, String var2, JobManager var3);
    }
}

