/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.schedule;

import java.util.Arrays;
import java.util.Map;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobProperties;
import pl.ds.websight.packagemanager.packageoptions.PackageImportOptions;
import pl.ds.websight.packagemanager.rest.PackagePrerequisiteValidator;
import pl.ds.websight.packagemanager.rest.packageaction.InstallPackageRestAction;
import pl.ds.websight.packagemanager.rest.packageaction.UninstallPackageRestAction;

public enum ScheduleActionType {
    INSTALL("Installation", "pl/ds/websight/packagemanager/packageaction/install", (packagePath, userId) -> PackageActionJobProperties.toMap(packagePath, PackageImportOptions.DEFAULT, userId), InstallPackageRestAction.ACTION_PRE_VALIDATORS),
    BUILD("Build", "pl/ds/websight/packagemanager/packageaction/build", (packagePath, userId) -> PackageActionJobProperties.toMap(packagePath, PackageImportOptions.DEFAULT, userId), new PackagePrerequisiteValidator[0]),
    UNINSTALL("Uninstallation", "pl/ds/websight/packagemanager/packageaction/uninstall", (packagePath, userId) -> PackageActionJobProperties.toMap(packagePath, PackageImportOptions.DEFAULT, userId), UninstallPackageRestAction.ACTION_PRE_VALIDATOR),
    DELETE("Delete", "pl/ds/websight/packagemanager/packageaction/delete", JobProperties::toMap, new PackagePrerequisiteValidator[0]);

    private final String fullName;
    private final String jobTopic;
    private final JobPropertiesCreator creator;
    private final PackagePrerequisiteValidator[] validators;

    private ScheduleActionType(String fullName, String jobTopic, JobPropertiesCreator creator, PackagePrerequisiteValidator ... validators) {
        this.fullName = fullName;
        this.jobTopic = jobTopic;
        this.creator = creator;
        this.validators = validators;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTopic() {
        return this.jobTopic;
    }

    public Map<String, Object> getJobProperties(String packagePath, String userId) {
        return this.creator.create(packagePath, userId);
    }

    public PackagePrerequisiteValidator[] getValidators() {
        return this.validators;
    }

    public static ScheduleActionType from(String jobTopic) {
        return Arrays.stream(ScheduleActionType.values()).filter(actionType -> actionType.jobTopic.equals(jobTopic)).findFirst().orElse(null);
    }

    public static String getFullName(String jobTopic) {
        return Arrays.stream(ScheduleActionType.values()).filter(actionType -> actionType.jobTopic.equals(jobTopic)).findFirst().map(actionType -> actionType.fullName).orElse("Unknown action");
    }

    private static interface JobPropertiesCreator {
        public Map<String, Object> create(String var1, String var2);
    }
}

