/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.validation.constraints.NotNull;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=[\"GET\", \"POST\", \"PUT\"]"})
@SlingServletPaths(value={"/apps/websight-package-manager-service/bin/install"})
public class InstallPackageServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(InstallPackageServlet.class);
    private static final String FILE_PARAMETER = "file";
    @Reference
    private transient Packaging packaging;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.getWriter().append("InstallPackageServlet is running.");
        response.setStatus(200);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.doInstall(request, response);
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        this.doInstall(request, response);
    }

    private void doInstall(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        RequestParameter file = request.getRequestParameter(FILE_PARAMETER);
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be empty");
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("Session is null");
        }
        LOG.info("Attempting to install package: {}", (Object)file.getFileName());
        int status = this.install(file, session);
        response.getWriter().append("<document><response><status><code>" + status + "</code></status></response></document>");
        response.setStatus(status);
    }

    private int install(@NotNull RequestParameter file, @NotNull Session session) {
        int n;
        block10: {
            InputStream is = file.getInputStream();
            try {
                JcrPackageManager manager = this.packaging.getPackageManager(session);
                JcrPackage jcrPackage = manager.upload(is, true);
                ImportOptions options = new ImportOptions();
                options.setAccessControlHandling(AccessControlHandling.MERGE);
                jcrPackage.install(options);
                n = 200;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return 500;
                }
                catch (PackageException e) {
                    LOG.error("Error during package installation", (Throwable)e);
                    return 500;
                }
                catch (IOException e) {
                    LOG.error("Error while reading input file", (Throwable)e);
                    return 500;
                }
            }
            is.close();
        }
        return n;
    }
}

