/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public final class DateUtil {
    public static final String DATE_TIME_FORMAT_PATTERN = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.getPattern();
    public static final String DATE_TIME_ZONE_FORMAT_PATTERN = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern();

    private DateUtil() {
    }

    public static Date parseDateTime(String dateString) throws ParseException {
        return DateUtils.parseDate((String)dateString, (String[])new String[]{DATE_TIME_FORMAT_PATTERN});
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return DateFormatUtils.format((Date)date, (String)DATE_TIME_ZONE_FORMAT_PATTERN, (TimeZone)DateUtil.getTimeZone());
    }

    public static String format(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return DateFormatUtils.format((Calendar)calendar, (String)DATE_TIME_ZONE_FORMAT_PATTERN, (TimeZone)DateUtil.getTimeZone());
    }

    private static TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }
}

