/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.dto;

import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;

public class ResourceListDto {
    private final String name;
    private final String path;
    private final String type;
    private final List<String> providers;
    private String shadowedBy;
    private final boolean hasContent;
    private final boolean hasChildren;
    private boolean orderable;
    private List<ResourceListDto> children;

    public ResourceListDto(ResourceWrapper providedResource, String shadowedBy, boolean hasContent, boolean hasChildren, boolean orderable) {
        this.name = providedResource.getName();
        this.path = providedResource.getPath();
        this.type = providedResource.getPrimaryVariant() != null ? providedResource.getPrimaryVariant().getValue().getResourceType() : null;
        this.shadowedBy = shadowedBy;
        this.providers = providedResource.getAvailableProviders();
        this.hasContent = hasContent;
        this.hasChildren = hasChildren;
        this.orderable = orderable;
    }

    public ResourceListDto(Resource resource, List<String> providers, boolean hasContent) {
        this.name = resource.getName();
        this.path = resource.getPath();
        this.type = resource.getResourceType();
        this.providers = providers;
        this.hasContent = hasContent;
        this.hasChildren = resource.hasChildren();
    }

    public void addChild(ResourceListDto child) {
        if (this.children == null) {
            this.children = new LinkedList<ResourceListDto>();
        }
        this.children.add(child);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public String getShadowedBy() {
        return this.shadowedBy;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public boolean isHasContent() {
        return this.hasContent;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public List<ResourceListDto> getChildren() {
        return this.children;
    }
}

