/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.dto;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import pl.ds.websight.resourcebrowser.api.AbstractPropertyDto;

public class ResourcePropertyDto
extends AbstractPropertyDto {
    public ResourcePropertyDto(String name, Object value) {
        this.name = name;
        if (value != null) {
            if (value.getClass().isArray()) {
                this.value = Arrays.stream((Object[])value).map(this::initValue).collect(Collectors.toList());
                this.type = this.type + "[]";
            } else {
                this.value = this.initValue(value);
            }
        }
    }

    private Object initValue(Object value) {
        if (value instanceof Calendar) {
            this.type = "Date";
            return DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format((Calendar)value);
        }
        if (value instanceof InputStream) {
            this.type = "Binary";
            return "[binary value]";
        }
        this.type = value.getClass().getSimpleName();
        return value;
    }
}

