/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.resourceprovider;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.resourceprovider.BasicResolveContext;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProviderInfo;
import pl.ds.websight.resourcebrowser.service.impl.ResourceBrowserServiceImpl;

public class AuthenticatedResourceProvider
implements Comparable<AuthenticatedResourceProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedResourceProvider.class);
    private final ResourceProvider<Object> resourceProvider;
    private final ResolveContext<Object> resolveContext;
    private final ResourceProviderInfo info;
    private final Resource rootResource;

    public AuthenticatedResourceProvider(ResourceBrowserServiceImpl.ResourceProviderStorageItem resourceProviderStorageItem, ResourceResolver resourceResolver) {
        this.resourceProvider = resourceProviderStorageItem.getResourceProvider();
        this.info = resourceProviderStorageItem.getInfo();
        this.resolveContext = this.authenticate(resourceResolver, this.info.getAuthenticate());
        this.rootResource = this.getResource(null, this.info.getRoot());
    }

    private ResolveContext<Object> authenticate(ResourceResolver resourceResolver, String authenticate) {
        Object providerState = null;
        try {
            HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
            authenticationInfo.put("provider.auth.clone", true);
            authenticationInfo.put("provider.authenticate", authenticate);
            authenticationInfo.put("user.jcr.session", resourceResolver.adaptTo(Session.class));
            providerState = this.resourceProvider.authenticate(authenticationInfo);
        }
        catch (LoginException e) {
            LOG.warn("Could not authenticate resource provider", (Throwable)e);
        }
        return new BasicResolveContext<Object>(resourceResolver, providerState);
    }

    public void copyResource(String source, String destination) throws PersistenceException {
        if (StringUtils.isNotBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)destination)) {
            this.resourceProvider.copy(this.resolveContext, source, destination);
        }
    }

    public Resource createResource(Resource parent, String name, Map<String, Object> properties) throws PersistenceException {
        if (parent != null) {
            return this.resourceProvider.create(this.resolveContext, StringUtils.appendIfMissing((String)parent.getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + name, properties);
        }
        return null;
    }

    public void removeResource(Resource parent, String name) throws PersistenceException {
        Resource resourceToRemove;
        if (parent != null && (resourceToRemove = parent.getChild(name)) != null) {
            this.resourceProvider.delete(this.resolveContext, resourceToRemove);
        }
    }

    public Resource getResource(Resource parent, String path) {
        try {
            return this.resourceProvider.getResource(this.resolveContext, path, ResourceContext.EMPTY_CONTEXT, parent);
        }
        catch (Exception e) {
            LOG.warn("Could not get resource {} from {}", new Object[]{path, this.info.getName(), e});
            return null;
        }
    }

    public Iterator<Resource> listChildren(Resource parent) {
        try {
            return this.resourceProvider.listChildren(this.resolveContext, parent);
        }
        catch (Exception e) {
            LOG.warn("Could not list children of {} from {}", new Object[]{parent.getPath(), this.info.getName(), e});
            return null;
        }
    }

    public void commit() throws PersistenceException {
        if (this.resourceProvider.hasChanges(this.resolveContext)) {
            this.resourceProvider.commit(this.resolveContext);
        }
    }

    public Resource getRootResource() {
        return this.rootResource;
    }

    @Override
    public int compareTo(AuthenticatedResourceProvider other) {
        return this.info.compareTo(other.getInfo());
    }

    public ResourceProviderInfo getInfo() {
        return this.info;
    }
}

