/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.resourceprovider;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResourceProviderInfo
implements Comparable<ResourceProviderInfo> {
    private final String name;
    private final String authenticate;
    private final String root;
    private final boolean modifiable;

    public ResourceProviderInfo(String name, Map<String, Object> properties) {
        this.name = name;
        this.authenticate = ResourceProviderInfo.getStringProperty("provider.authenticate", properties);
        this.root = ResourceProviderInfo.getStringProperty("provider.root", properties);
        this.modifiable = (Boolean)properties.getOrDefault("provider.modifiable", false);
    }

    private static String getStringProperty(String name, Map<String, Object> properties) {
        return properties.containsKey(name) ? properties.get(name).toString() : null;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthenticate() {
        return this.authenticate;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public int compareTo(ResourceProviderInfo other) {
        Integer otherRootLevel;
        Integer rootLevel = this.getRootLevel();
        if (rootLevel.equals(otherRootLevel = other.getRootLevel())) {
            return StringUtils.compareIgnoreCase((String)this.root, (String)other.getRoot());
        }
        return rootLevel.compareTo(otherRootLevel);
    }

    public String getRoot() {
        return this.root;
    }

    private Integer getRootLevel() {
        return StringUtils.countMatches((CharSequence)this.root, (char)'/');
    }
}

