/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.resourceprovider;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.service.impl.ResourceBrowserServiceImpl;

public class ResourceProvidersControl {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceProvidersControl.class);
    private final List<AuthenticatedResourceProvider> authResourceProviders;

    public ResourceProvidersControl(List<ResourceBrowserServiceImpl.ResourceProviderStorageItem> resourceProviders, ResourceResolver resourceResolver) {
        this.authResourceProviders = ResourceProvidersControl.authenticate(resourceProviders, resourceResolver);
    }

    private static List<AuthenticatedResourceProvider> authenticate(List<ResourceBrowserServiceImpl.ResourceProviderStorageItem> resourceProviders, ResourceResolver resourceResolver) {
        return resourceProviders.stream().map(item -> new AuthenticatedResourceProvider((ResourceBrowserServiceImpl.ResourceProviderStorageItem)item, resourceResolver)).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    public AuthenticatedResourceProvider getBestMatchingProvider(String path) {
        return this.streamOfProvidersForPath(path).findFirst().orElse(null);
    }

    public ResourceWrapper getResource(ResourceResolver resourceResolver, String path) {
        ResourceWrapper resource = null;
        List providers = this.streamOfProvidersForPath(path).collect(Collectors.toList());
        for (AuthenticatedResourceProvider authProvider : providers) {
            Resource providedResource = authProvider.getResource(null, path);
            if (providedResource == null) continue;
            if (resource == null) {
                resource = new ResourceWrapper(providedResource);
            }
            resource.addVariant(authProvider, providedResource);
        }
        if (resource == null && !this.getProvidersRegisteredBelowPath(path).isEmpty()) {
            SyntheticResource linkResource = new SyntheticResource(resourceResolver, path, "sling:syntheticResourceProviderResource");
            resource = new ResourceWrapper((Resource)linkResource);
        }
        return resource;
    }

    public List<ResourceWrapper> listChildren(ResourceWrapper parentProvidedResource) {
        LinkedList<ResourceWrapper> resources = new LinkedList<ResourceWrapper>();
        for (Map.Entry<AuthenticatedResourceProvider, Resource> resourceVariant : parentProvidedResource.getVariants().entrySet()) {
            AuthenticatedResourceProvider authProvider = resourceVariant.getKey();
            Iterator<Resource> children = authProvider.listChildren(resourceVariant.getValue());
            if (children == null) continue;
            children.forEachRemaining(resource -> ResourceProvidersControl.addOrUpdateResource(resources, authProvider, resource));
        }
        this.listChildrenRegisteredBelowParent(resources, parentProvidedResource);
        if (ResourceProvidersControl.shouldSort(parentProvidedResource)) {
            resources.sort(Comparator.comparing(ResourceWrapper::getName, String.CASE_INSENSITIVE_ORDER));
        }
        return resources;
    }

    private void listChildrenRegisteredBelowParent(List<ResourceWrapper> resources, ResourceWrapper parentProvidedResource) {
        String parentPath = parentProvidedResource.getPath();
        for (AuthenticatedResourceProvider provider : this.getProvidersRegisteredBelowPath(parentPath)) {
            String providerRootPath = provider.getInfo().getRoot();
            boolean isRegisteredAsDirectlyBelowParent = parentPath.equals(ResourceUtil.getParent((String)providerRootPath));
            if (isRegisteredAsDirectlyBelowParent) {
                ResourceProvidersControl.addOrUpdateResource(resources, provider, provider.getRootResource());
                continue;
            }
            String relativePathWithTrailingSlash = this.relativizePath(parentPath, providerRootPath);
            String nameOfDirectChild = StringUtils.substringBefore((String)relativePathWithTrailingSlash, (String)"/");
            String path = StringUtils.appendIfMissing((String)parentProvidedResource.getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + nameOfDirectChild;
            boolean isAlreadyPresent = resources.stream().anyMatch(resource -> StringUtils.equals((CharSequence)resource.getPath(), (CharSequence)path));
            if (isAlreadyPresent) continue;
            resources.add(new ResourceWrapper(nameOfDirectChild, path));
        }
    }

    private static void addOrUpdateResource(List<ResourceWrapper> resources, AuthenticatedResourceProvider provider, Resource resource) {
        if (resource != null) {
            ResourceWrapper providedResource = resources.stream().filter(r -> StringUtils.equals((CharSequence)r.getPath(), (CharSequence)resource.getPath())).findFirst().orElse(null);
            if (providedResource == null) {
                providedResource = new ResourceWrapper(resource);
                resources.add(providedResource);
            }
            providedResource.addVariant(provider, resource);
        }
    }

    private String relativizePath(String rootPathCandidate, String pathToRelativize) {
        return StringUtils.removeStart((String)StringUtils.appendIfMissing((String)pathToRelativize, (CharSequence)"/", (CharSequence[])new CharSequence[0]), (String)StringUtils.appendIfMissing((String)rootPathCandidate, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public static boolean shouldSort(ResourceWrapper providedParent) {
        for (Resource parent : providedParent.getVariants().values()) {
            Node node = (Node)parent.adaptTo(Node.class);
            if (node == null) continue;
            try {
                return !ResourceProvidersControl.hasOrderableChildNodes(node);
            }
            catch (RepositoryException e) {
                LOG.warn("Could not get Node Type Definition for Node: {}", (Object)parent.getPath(), (Object)e);
            }
        }
        return true;
    }

    private static boolean hasOrderableChildNodes(Node node) throws RepositoryException {
        return node.getPrimaryNodeType().hasOrderableChildNodes() || Arrays.stream(node.getMixinNodeTypes()).anyMatch(NodeTypeDefinition::hasOrderableChildNodes);
    }

    public boolean hasChildren(ResourceWrapper parentProvidedResource) {
        return !this.listChildren(parentProvidedResource).isEmpty();
    }

    private List<AuthenticatedResourceProvider> getProvidersRegisteredBelowPath(String path) {
        return this.authResourceProviders.stream().filter(provider -> {
            String providerRoot = provider.getInfo().getRoot();
            return !providerRoot.equals(path) && ResourceProvidersControl.pathStartsWith(providerRoot, path);
        }).collect(Collectors.toList());
    }

    private Stream<AuthenticatedResourceProvider> streamOfProvidersForPath(String path) {
        return this.authResourceProviders.stream().filter(provider -> ResourceProvidersControl.pathStartsWith(path, provider.getInfo().getRoot()));
    }

    private static boolean pathStartsWith(String path, String prefixPath) {
        String pathToCompare = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String prefixPathToCompare = StringUtils.appendIfMissing((String)prefixPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return StringUtils.startsWith((CharSequence)pathToCompare, (CharSequence)prefixPathToCompare);
    }
}

