/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.resourceprovider;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;

public class ResourceWrapper {
    private final Map<AuthenticatedResourceProvider, Resource> variants = new LinkedHashMap<AuthenticatedResourceProvider, Resource>();
    private final String name;
    private final String path;

    public ResourceWrapper(Resource resource) {
        this.name = resource.getName();
        this.path = resource.getPath();
    }

    public ResourceWrapper(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public void addVariant(AuthenticatedResourceProvider authProvider, Resource resource) {
        this.variants.put(authProvider, resource);
    }

    public Map<AuthenticatedResourceProvider, Resource> getVariants() {
        return this.variants;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getAvailableProviders() {
        return this.variants.keySet().stream().sorted(Comparator.reverseOrder()).map(provider -> provider.getInfo().getName()).distinct().collect(Collectors.toList());
    }

    public Map.Entry<AuthenticatedResourceProvider, Resource> getPrimaryVariant() {
        if (this.variants.size() > 0) {
            return this.variants.entrySet().iterator().next();
        }
        return null;
    }
}

