/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.api.AbstractPropertyDto;
import pl.ds.websight.resourcebrowser.api.SaveOperationProcessor;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProviderInfo;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.rest.AbstractRestAction;
import pl.ds.websight.resourcebrowser.rest.Messages;
import pl.ds.websight.resourcebrowser.rest.ProvidedResourceRestModel;
import pl.ds.websight.resourcebrowser.rest.processor.impl.SaveOperationProcessors;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class GetPropertiesRestAction
extends AbstractRestAction<ProvidedResourceRestModel, Map<String, List<AbstractPropertyDto>>>
implements RestAction<ProvidedResourceRestModel, Map<String, List<AbstractPropertyDto>>> {
    private static final Logger LOG = LoggerFactory.getLogger(GetPropertiesRestAction.class);
    @Reference
    private ResourceBrowserService resourceBrowserService;
    @Reference
    private SaveOperationProcessors saveOperationProcessors;

    @Override
    protected RestActionResult<Map<String, List<AbstractPropertyDto>>> performAction(ProvidedResourceRestModel model) {
        ResourceResolver resourceResolver = model.getResourceResolver();
        String path = model.getPath();
        ResourceProvidersControl providersControl = this.resourceBrowserService.getResourceProvidersControl(model.getProviders(), resourceResolver);
        ResourceWrapper providedResource = providersControl.getResource(resourceResolver, path);
        if (providedResource == null) {
            LOG.warn("Could not find resource '{}'", (Object)path);
            return RestActionResult.failure((String)"Could not fetch properties", (String)Messages.formatMessage("Could not find resource '%s'", path));
        }
        return RestActionResult.success(this.createPropertiesMap(providedResource));
    }

    private Map<String, List<AbstractPropertyDto>> createPropertiesMap(ResourceWrapper providedResource) {
        HashMap<String, List<AbstractPropertyDto>> properties = new HashMap<String, List<AbstractPropertyDto>>();
        for (Map.Entry<AuthenticatedResourceProvider, Resource> variant : providedResource.getVariants().entrySet()) {
            ResourceProviderInfo providerInfo = variant.getKey().getInfo();
            SaveOperationProcessor processor = this.saveOperationProcessors.getProcessor(variant);
            properties.put(providerInfo.getName(), processor.getProperties(variant.getValue()));
        }
        return properties;
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not fetch properties";
    }
}

