/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest;

import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.dto.ResourceContentDataDto;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProviderInfo;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.rest.AbstractRestAction;
import pl.ds.websight.resourcebrowser.rest.Messages;
import pl.ds.websight.resourcebrowser.rest.ProvidedResourceRestModel;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;
import pl.ds.websight.resourcebrowser.service.impl.ResourceContentService;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class GetResourceContentDataRestAction
extends AbstractRestAction<ProvidedResourceRestModel, ResourceContentDataDto>
implements RestAction<ProvidedResourceRestModel, ResourceContentDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(GetResourceContentDataRestAction.class);
    @Reference
    private ResourceBrowserService resourceBrowserService;
    @Reference
    private ResourceContentService resourceContentService;

    @Override
    protected RestActionResult<ResourceContentDataDto> performAction(ProvidedResourceRestModel model) {
        String path = model.getPath();
        ResourceResolver resourceResolver = model.getResourceResolver();
        ResourceProvidersControl providersControl = this.resourceBrowserService.getResourceProvidersControl(model.getProviders(), resourceResolver);
        ResourceWrapper providedResource = providersControl.getResource(resourceResolver, path);
        if (providedResource == null) {
            LOG.warn("Could not find resource '{}'", (Object)path);
            return RestActionResult.failure((String)"Could not fetch resource", (String)Messages.formatMessage("Could not find resource '%s'", path));
        }
        Map.Entry<AuthenticatedResourceProvider, Resource> primaryVariant = providedResource.getPrimaryVariant();
        if (primaryVariant == null) {
            LOG.warn("Could not find resource '{}' within requested providers", (Object)path);
            return RestActionResult.failure((String)"Could not fetch resource", (String)Messages.formatMessage("Could not find resource '%s' within requested providers", path));
        }
        if (!this.resourceContentService.hasContent(primaryVariant)) {
            return RestActionResult.failure((String)"Could not fetch resource content", (String)Messages.formatMessage("Could not read resource '%s' binary content", path));
        }
        String mimeType = this.resourceContentService.getMimeType(primaryVariant);
        String sourcePath = this.resourceContentService.getSourcePath(primaryVariant);
        ResourceProviderInfo providerInfo = primaryVariant.getKey().getInfo();
        return RestActionResult.success((Object)new ResourceContentDataDto(mimeType, providerInfo.getName(), sourcePath, !providerInfo.isModifiable()));
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not fetch resource content";
    }
}

