/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.rest.AbstractRestAction;
import pl.ds.websight.resourcebrowser.rest.ProvidedResourceRestModel;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;
import pl.ds.websight.resourcebrowser.service.impl.ResourceContentService;
import pl.ds.websight.rest.framework.FreeFormResponse;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class GetResourceContentRestAction
extends AbstractRestAction<ProvidedResourceRestModel, FreeFormResponse>
implements RestAction<ProvidedResourceRestModel, FreeFormResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(GetResourceContentRestAction.class);
    @Reference
    private ResourceBrowserService resourceBrowserService;
    @Reference
    private ResourceContentService resourceContentService;

    @Override
    protected RestActionResult<FreeFormResponse> performAction(ProvidedResourceRestModel model) {
        return RestActionResult.freeFormResponse(response -> {
            Map.Entry<AuthenticatedResourceProvider, Resource> primaryVariant = this.getPrimaryVariant(model);
            if (primaryVariant == null) {
                LOG.warn("Could not find resource '{}' within requested providers", (Object)model.getPath());
                response.sendError(404);
                return;
            }
            response.setHeader("Cache-Control", "no-store");
            try (InputStream contentStream = this.resourceContentService.getContent(primaryVariant);){
                if (contentStream == null) {
                    LOG.warn("Could not get content for resource '{}' within requested providers", (Object)model.getPath());
                    response.sendError(404);
                    return;
                }
                response.setContentType(this.resourceContentService.getMimeType(primaryVariant));
                IOUtils.copy((InputStream)contentStream, (OutputStream)response.getOutputStream());
            }
        });
    }

    private Map.Entry<AuthenticatedResourceProvider, Resource> getPrimaryVariant(ProvidedResourceRestModel model) {
        ResourceResolver resourceResolver = model.getResourceResolver();
        String path = model.getPath();
        List<String> providers = model.getProviders();
        ResourceProvidersControl providersControl = this.resourceBrowserService.getResourceProvidersControl(providers, resourceResolver);
        ResourceWrapper providedResource = providersControl.getResource(resourceResolver, path);
        if (providedResource == null) {
            LOG.warn("Could not find resource '{}'", (Object)path);
            return null;
        }
        return providedResource.getPrimaryVariant();
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not fetch resource content";
    }
}

