/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest;

import java.util.List;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import pl.ds.websight.resourcebrowser.dto.ResourceProviderDto;
import pl.ds.websight.resourcebrowser.rest.AbstractRestAction;
import pl.ds.websight.resourcebrowser.rest.ListResourceProvidersRestModel;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class ListResourceProvidersRestAction
extends AbstractRestAction<ListResourceProvidersRestModel, List<ResourceProviderDto>>
implements RestAction<ListResourceProvidersRestModel, List<ResourceProviderDto>> {
    @Reference
    private ResourceBrowserService resourceBrowserService;

    @Override
    protected RestActionResult<List<ResourceProviderDto>> performAction(ListResourceProvidersRestModel model) {
        List availableProviders = this.resourceBrowserService.listAvailableProviders().stream().map(providerInfo -> new ResourceProviderDto(providerInfo.getName(), providerInfo.isModifiable())).distinct().collect(Collectors.toList());
        return RestActionResult.success(availableProviders);
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not list resource providers";
    }
}

