/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import pl.ds.websight.resourcebrowser.dto.ResourceListDto;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.rest.AbstractRestAction;
import pl.ds.websight.resourcebrowser.rest.ListResourcesRestModel;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;
import pl.ds.websight.resourcebrowser.service.impl.ResourceContentService;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
public class ListResourcesRestAction
extends AbstractRestAction<ListResourcesRestModel, List<ResourceListDto>>
implements RestAction<ListResourcesRestModel, List<ResourceListDto>> {
    @Reference
    private ResourceBrowserService resourceBrowserService;
    @Reference
    private ResourceContentService resourceContentService;

    @Override
    protected RestActionResult<List<ResourceListDto>> performAction(ListResourcesRestModel model) {
        ResourceResolver resourceResolver = model.getResourceResolver();
        ResourceProvidersControl providersControl = this.resourceBrowserService.getResourceProvidersControl(model.getProviders(), resourceResolver);
        LinkedList<ResourceListDto> resources = new LinkedList<ResourceListDto>();
        for (ResourceWrapper parentProvidedResource : this.getRootResources(providersControl, resourceResolver, model.getPaths())) {
            ResourceListDto resourceListDto = this.createListResourcesItem(parentProvidedResource, resourceResolver, providersControl);
            providersControl.listChildren(parentProvidedResource).stream().map(providedResource -> this.createListResourcesItem((ResourceWrapper)providedResource, resourceResolver, providersControl)).forEachOrdered(resourceListDto::addChild);
            resources.add(resourceListDto);
        }
        return RestActionResult.success(resources);
    }

    private List<ResourceWrapper> getRootResources(ResourceProvidersControl providersControl, ResourceResolver resourceResolver, List<String> paths) {
        return paths.stream().map(path -> providersControl.getResource(resourceResolver, (String)path)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ResourceListDto createListResourcesItem(ResourceWrapper providedResource, ResourceResolver resourceResolver, ResourceProvidersControl providersControl) {
        AuthenticatedResourceProvider bestMatchingProvider;
        boolean hasChildren = providersControl.hasChildren(providedResource);
        String shadowedBy = null;
        String resourcePath = providedResource.getPath();
        if (resourceResolver.getResource(resourcePath) == null && (bestMatchingProvider = providersControl.getBestMatchingProvider(resourcePath)) != null) {
            shadowedBy = bestMatchingProvider.getInfo().getName();
        }
        boolean hasContent = this.resourceContentService.hasContent(providedResource.getPrimaryVariant());
        boolean orderable = !ResourceProvidersControl.shouldSort(providedResource);
        return new ResourceListDto(providedResource, shadowedBy, hasContent, hasChildren, orderable);
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not list resources";
    }
}

