/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest.processor.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import pl.ds.websight.resourcebrowser.api.AbstractPropertyDto;
import pl.ds.websight.resourcebrowser.api.SaveOperationProcessor;
import pl.ds.websight.resourcebrowser.dto.ResourcePropertyDto;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.rest.requestparameter.saveoperation.CreateResourceOperation;
import pl.ds.websight.resourcebrowser.rest.requestparameter.saveoperation.MoveResourceOperation;
import pl.ds.websight.resourcebrowser.rest.requestparameter.saveoperation.SetPropertyOperation;

public class DefaultSaveOperationProcessor
implements SaveOperationProcessor {
    private final AuthenticatedResourceProvider provider;

    public DefaultSaveOperationProcessor(AuthenticatedResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public List<AbstractPropertyDto> getProperties(Resource resource) {
        return resource.getValueMap().entrySet().stream().map(propertyEntry -> new ResourcePropertyDto((String)propertyEntry.getKey(), propertyEntry.getValue())).sorted(Comparator.comparing(AbstractPropertyDto::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
    }

    @Override
    public int copyResources(Resource resource, List<String> resourcesToCopy) throws PersistenceException {
        int resourceCopiesAmount = 0;
        if (resourcesToCopy != null) {
            String sourcePath = resource.getPath();
            for (String destinationPath : resourcesToCopy) {
                this.provider.copyResource(sourcePath, destinationPath);
                ++resourceCopiesAmount;
            }
        }
        return resourceCopiesAmount;
    }

    @Override
    public int createResources(Resource resource, List<CreateResourceOperation> resourcesToCreate) throws PersistenceException {
        int createResourcesAmount = 0;
        if (resourcesToCreate != null) {
            for (CreateResourceOperation resourceToCreate : resourcesToCreate) {
                createResourcesAmount += this.createResource(resourceToCreate, resource);
            }
        }
        return createResourcesAmount;
    }

    @Override
    public int moveResource(Resource resource, MoveResourceOperation moveOperation) throws PersistenceException {
        if (moveOperation != null) {
            Map properties = (Map)resource.adaptTo(ValueMap.class);
            String destinationName = StringUtils.substringAfterLast((String)moveOperation.getDestination(), (String)"/");
            Resource parentResource = resource.getParent();
            this.provider.createResource(parentResource, destinationName, properties);
            this.provider.removeResource(parentResource, resource.getName());
            return 1;
        }
        return 0;
    }

    @Override
    public int removeResources(Resource resource, List<String> resourcesToRemove) throws PersistenceException {
        int removeResourcesAmount = 0;
        if (resourcesToRemove != null) {
            for (String resourceToRemoveName : resourcesToRemove) {
                this.provider.removeResource(resource, resourceToRemoveName);
                ++removeResourcesAmount;
            }
        }
        return removeResourcesAmount;
    }

    private int createResource(CreateResourceOperation resourceToCreate, Resource parent) throws PersistenceException {
        int createNodesAmount = 0;
        String name = resourceToCreate.getName();
        Map<String, Object> properties = DefaultSaveOperationProcessor.getPropertiesToCreate(resourceToCreate);
        Resource createdResource = Objects.requireNonNull(this.provider.createResource(parent, name, properties), String.format("Could not create Resource %s under %s", name, parent.getPath()));
        for (CreateResourceOperation childToCreate : resourceToCreate.getChildren()) {
            createNodesAmount += this.createResource(childToCreate, createdResource);
        }
        return createNodesAmount + 1;
    }

    private static Map<String, Object> getPropertiesToCreate(CreateResourceOperation nodeToCreate) {
        List<SetPropertyOperation> propertiesToSet = nodeToCreate.getProperties();
        if (propertiesToSet != null) {
            HashMap<String, Object> propertiesToCreate = new HashMap<String, Object>();
            nodeToCreate.getProperties().forEach(property -> propertiesToCreate.put(property.getName(), property.getValues() == null ? property.getValue() : property.getValues()));
            return propertiesToCreate;
        }
        return null;
    }

    @Override
    public int setProperties(Resource resource, List<SetPropertyOperation> propertiesToSet) {
        if (propertiesToSet != null) {
            ModifiableValueMap properties = Objects.requireNonNull((ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class));
            propertiesToSet.forEach(property -> {
                boolean isMultiValue = property.getValues() != null;
                properties.put((Object)property.getName(), isMultiValue ? property.getValues() : property.getValue());
            });
            return propertiesToSet.size();
        }
        return 0;
    }

    @Override
    public int removeProperties(Resource resource, List<String> propertiesToRemove) {
        int removedPropertiesAmount = 0;
        if (propertiesToRemove != null) {
            ModifiableValueMap properties = Objects.requireNonNull((ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class));
            for (String propertyName : propertiesToRemove) {
                if (!properties.containsKey((Object)propertyName)) continue;
                properties.remove((Object)propertyName);
                ++removedPropertiesAmount;
            }
        }
        return removedPropertiesAmount;
    }
}

