/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.rest.processor.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.api.SaveOperationProcessor;
import pl.ds.websight.resourcebrowser.resourceprovider.AuthenticatedResourceProvider;
import pl.ds.websight.resourcebrowser.rest.processor.impl.DefaultSaveOperationProcessor;

@Component(service={SaveOperationProcessors.class})
public class SaveOperationProcessors {
    private static final Logger LOG = LoggerFactory.getLogger(SaveOperationProcessors.class);
    private final Map<String, SaveOperationProcessor> actionProcessors = new HashMap<String, SaveOperationProcessor>();

    public SaveOperationProcessor getProcessor(Map.Entry<AuthenticatedResourceProvider, Resource> variant) {
        AuthenticatedResourceProvider provider = variant.getKey();
        return this.actionProcessors.getOrDefault(provider.getInfo().getName(), new DefaultSaveOperationProcessor(provider));
    }

    @Reference(service=SaveOperationProcessor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindActionProcessors(SaveOperationProcessor processor, Map<String, Object> properties) {
        String handledProvider = (String)properties.get("provider");
        if (StringUtils.isNotBlank((CharSequence)handledProvider)) {
            LOG.error("Binding {}", (Object)processor.getClass().getName());
            this.actionProcessors.put(handledProvider, processor);
        }
    }

    protected synchronized void unbindActionProcessors(SaveOperationProcessor processor, Map<String, Object> properties) {
        String handledProvider = (String)properties.get("provider");
        if (StringUtils.isNotBlank((CharSequence)handledProvider)) {
            LOG.error("Unbinding {}", (Object)processor.getClass().getName());
            this.actionProcessors.remove(handledProvider, processor);
        }
    }
}

