/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.service.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.autosuggestion.dto.SuggestionDto;
import pl.ds.websight.autosuggestion.dto.SuggestionListDto;
import pl.ds.websight.autosuggestion.service.AutosuggestionService;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceWrapper;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;

@Component(service={AutosuggestionService.class})
public class AutosuggestionHandlerServiceImpl
implements AutosuggestionService {
    private static final Logger LOG = LoggerFactory.getLogger(AutosuggestionHandlerServiceImpl.class);
    private static final String AUTOSUGGESTION_SERVICE_TYPE = "resource-browser";
    private static final String REQUEST_PARAMETER_PROVIDERS = "providers";
    private static final String REQUEST_PARAMETER_HAS_CHILDREN = "hasChildren";
    private static final String REQUEST_PARAMETER_BASE_PATH = "basePath";
    private static final String REQUEST_PARAMETER_QUERY = "query";
    private static final String REQUEST_PARAMETER_LIMIT = "limit";
    private static final int MAX_RESULTS_SIZE = 100;
    @Reference
    private ResourceBrowserService resourceBrowserService;

    public String getType() {
        return AUTOSUGGESTION_SERVICE_TYPE;
    }

    public SuggestionListDto getSuggestions(ResourceResolver resourceResolver, RequestParameterMap requestParameterMap) {
        RequestParameter[] providersParameter = requestParameterMap.getValues(REQUEST_PARAMETER_PROVIDERS);
        if (providersParameter == null) {
            LOG.warn("Could not get required parameter '{}'", (Object)REQUEST_PARAMETER_PROVIDERS);
            return SuggestionListDto.buildEmpty();
        }
        String basePath = (String)StringUtils.defaultIfBlank((CharSequence)AutosuggestionHandlerServiceImpl.getParamStringValue(requestParameterMap, REQUEST_PARAMETER_BASE_PATH), (CharSequence)"/");
        if (!StringUtils.startsWith((CharSequence)basePath, (CharSequence)"/")) {
            LOG.warn("Parameter '{}' is not absolute path '{}'", (Object)REQUEST_PARAMETER_BASE_PATH, (Object)basePath);
            return SuggestionListDto.buildEmpty();
        }
        ResourceProvidersControl providersControl = this.resourceBrowserService.getResourceProvidersControl(AutosuggestionHandlerServiceImpl.getProvidersNames(providersParameter), resourceResolver);
        ResourceWrapper providedParent = providersControl.getResource(resourceResolver, basePath);
        if (providedParent == null) {
            LOG.warn("Could not find resource from '{}' parameter", (Object)REQUEST_PARAMETER_BASE_PATH);
            return SuggestionListDto.buildEmpty();
        }
        int limit = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)AutosuggestionHandlerServiceImpl.getParamStringValue(requestParameterMap, REQUEST_PARAMETER_LIMIT), (CharSequence)"10"));
        String query = (String)StringUtils.defaultIfBlank((CharSequence)AutosuggestionHandlerServiceImpl.getParamStringValue(requestParameterMap, REQUEST_PARAMETER_QUERY), (CharSequence)"");
        return AutosuggestionHandlerServiceImpl.createSuggestionList(providersControl, providedParent, query, Math.min(limit, 100));
    }

    private static List<String> getProvidersNames(RequestParameter[] providersParameter) {
        return Arrays.stream(providersParameter).map(RequestParameter::getString).collect(Collectors.toList());
    }

    private static SuggestionListDto createSuggestionList(ResourceProvidersControl providersControl, ResourceWrapper providedParent, String query, int limit) {
        List suggestions = providersControl.listChildren(providedParent).stream().filter(child -> StringUtils.startsWith((CharSequence)child.getName(), (CharSequence)query)).map(providedResource -> AutosuggestionHandlerServiceImpl.createSuggestion(providedResource, providersControl)).sorted(Comparator.comparing(SuggestionDto::getValue)).limit((long)limit + 1L).collect(Collectors.toList());
        boolean hasMore = suggestions.size() > limit;
        return SuggestionListDto.buildFromSuggestions(hasMore ? suggestions.subList(0, limit) : suggestions, (boolean)hasMore);
    }

    private static SuggestionDto createSuggestion(ResourceWrapper providedResource, ResourceProvidersControl providersControl) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(REQUEST_PARAMETER_PROVIDERS, providedResource.getAvailableProviders());
        data.put(REQUEST_PARAMETER_HAS_CHILDREN, providersControl.hasChildren(providedResource));
        return new SuggestionDto(providedResource.getName(), data);
    }

    private static String getParamStringValue(RequestParameterMap requestParameterMap, String paramName) {
        RequestParameter value = requestParameterMap.getValue(paramName);
        return value != null ? value.getString() : null;
    }
}

