/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.service.impl;

import java.io.InputStream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import pl.ds.websight.resourcebrowser.api.ResourceContentProvider;

@Component(service={DefaultResourceContentProvider.class})
public class DefaultResourceContentProvider
implements ResourceContentProvider {
    private static final String DEFAULT_RESOURCE_CONTENT_TYPE = "application/octet-stream";
    @Reference
    private MimeTypeService mimeTypeService;

    @Override
    public InputStream getContent(Resource resource) {
        if (resource != null) {
            return (InputStream)resource.adaptTo(InputStream.class);
        }
        return null;
    }

    @Override
    public String getSourcePath(Resource resource) {
        return null;
    }

    @Override
    public String getMimeType(Resource resource) {
        String mimeType = null;
        if (this.hasContent(resource)) {
            mimeType = resource.getResourceMetadata().getContentType();
            if (mimeType == null) {
                mimeType = this.mimeTypeService.getMimeType(resource.getName());
            }
            if (mimeType == null) {
                mimeType = DEFAULT_RESOURCE_CONTENT_TYPE;
            }
        }
        return mimeType;
    }

    @Override
    public boolean hasContent(Resource resource) {
        return "nt:file".equals(resource.getResourceType());
    }
}

