/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.resourcebrowser.service.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProviderInfo;
import pl.ds.websight.resourcebrowser.resourceprovider.ResourceProvidersControl;
import pl.ds.websight.resourcebrowser.service.ResourceBrowserService;

@Component(service={ResourceBrowserService.class})
public class ResourceBrowserServiceImpl
implements ResourceBrowserService {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBrowserServiceImpl.class);
    private final Map<String, ResourceProviderStorageItem> resourceProviders = new HashMap<String, ResourceProviderStorageItem>();

    @Override
    public ResourceProvidersControl getResourceProvidersControl(List<String> providerNames, ResourceResolver resourceResolver) {
        List<ResourceProviderStorageItem> requestedProviders = this.resourceProviders.values().stream().filter(item -> providerNames.contains(item.getInfo().getName())).collect(Collectors.toList());
        return new ResourceProvidersControl(requestedProviders, resourceResolver);
    }

    @Override
    public List<ResourceProviderInfo> listAvailableProviders() {
        return this.resourceProviders.values().stream().map(ResourceProviderStorageItem::getInfo).filter(ResourceBrowserServiceImpl.distinctByField(ResourceProviderInfo::getName)).sorted(Comparator.comparing(o -> StringUtils.substringAfterLast((String)o.getName(), (String)"."))).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByField(Function<? super T, ?> fieldExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(fieldExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Reference(service=ResourceProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected synchronized void bindResourceProviders(ResourceProvider<Object> resourceProvider, Map<String, Object> properties) {
        LOG.debug("Binding {}", (Object)resourceProvider.getClass().getName());
        String rootPath = (String)properties.get("provider.root");
        if (StringUtils.isNotBlank((CharSequence)rootPath)) {
            this.resourceProviders.put(rootPath, new ResourceProviderStorageItem(resourceProvider, properties));
        }
    }

    protected synchronized void unbindResourceProviders(ResourceProvider<Object> resourceProvider, Map<String, Object> properties) {
        LOG.debug("Unbinding {}", (Object)resourceProvider.getClass().getName());
        String rootPath = (String)properties.get("provider.root");
        this.resourceProviders.remove(rootPath);
    }

    public static class ResourceProviderStorageItem {
        private final ResourceProvider<Object> resourceProvider;
        private final ResourceProviderInfo info;

        public ResourceProviderStorageItem(ResourceProvider<Object> resourceProvider, Map<String, Object> properties) {
            this.resourceProvider = resourceProvider;
            this.info = new ResourceProviderInfo(resourceProvider.getClass().getName(), properties);
        }

        public ResourceProvider<Object> getResourceProvider() {
            return this.resourceProvider;
        }

        public ResourceProviderInfo getInfo() {
            return this.info;
        }
    }
}

