/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.root.redirect;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.Designate;
import pl.ds.websight.root.redirect.RootRedirectServletConfig;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"rep:root", "sling:OrderedFolder"})
@Designate(ocd=RootRedirectServletConfig.class)
public class RootRedirectServlet
extends SlingSafeMethodsServlet
implements OptingServlet {
    private static final String JCR_ROOT = "/";
    private static final String CONTENT_ROOT = "/content";
    private String redirectTarget;
    private boolean isPermanent;

    @Activate
    private void init(RootRedirectServletConfig config) {
        this.redirectTarget = config.redirectTarget();
        this.isPermanent = config.isPermanent();
    }

    public void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        if (this.isPermanent) {
            response.setStatus(301);
        } else {
            response.setStatus(302);
        }
        response.sendRedirect(this.redirectTarget);
    }

    public boolean accepts(@NotNull SlingHttpServletRequest request) {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String requestedPath = requestPathInfo.getResourcePath();
        return (requestedPath.equals(JCR_ROOT) || requestedPath.equals(CONTENT_ROOT)) && requestPathInfo.getExtension() == null && requestPathInfo.getSelectors().length == 0;
    }
}

