/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import pl.execon.fsp.core.FilterInfo;
import pl.execon.fsp.core.PageInfo;
import pl.execon.fsp.core.SortInfo;

public class FspRequest {
    public static final int INITIAL_PAGE_NUMBER = 0;
    private List<FilterInfo> filter = new ArrayList<FilterInfo>();
    private List<SortInfo> sort;
    private PageInfo page;

    public boolean hasPageInfo() {
        return Objects.nonNull(this.page);
    }

    protected FspRequest(FspRequestBuilder<?, ?> b) {
        this.filter = ((FspRequestBuilder)b).filter;
        this.sort = ((FspRequestBuilder)b).sort;
        this.page = ((FspRequestBuilder)b).page;
    }

    public static FspRequestBuilder<?, ?> builder() {
        return new FspRequestBuilderImpl();
    }

    public List<FilterInfo> getFilter() {
        return this.filter;
    }

    public List<SortInfo> getSort() {
        return this.sort;
    }

    public PageInfo getPage() {
        return this.page;
    }

    public FspRequest() {
    }

    public FspRequest(List<FilterInfo> filter, List<SortInfo> sort, PageInfo page) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
    }

    public void setFilter(List<FilterInfo> filter) {
        this.filter = filter;
    }

    public void setSort(List<SortInfo> sort) {
        this.sort = sort;
    }

    public void setPage(PageInfo page) {
        this.page = page;
    }

    public String toString() {
        return "FspRequest(filter=" + this.getFilter() + ", sort=" + this.getSort() + ", page=" + this.getPage() + ")";
    }

    private static final class FspRequestBuilderImpl
    extends FspRequestBuilder<FspRequest, FspRequestBuilderImpl> {
        private FspRequestBuilderImpl() {
        }

        @Override
        protected FspRequestBuilderImpl self() {
            return this;
        }

        @Override
        public FspRequest build() {
            return new FspRequest(this);
        }
    }

    public static abstract class FspRequestBuilder<C extends FspRequest, B extends FspRequestBuilder<C, B>> {
        private List<FilterInfo> filter;
        private List<SortInfo> sort;
        private PageInfo page;

        protected abstract B self();

        public abstract C build();

        public B filter(List<FilterInfo> filter) {
            this.filter = filter;
            return this.self();
        }

        public B sort(List<SortInfo> sort) {
            this.sort = sort;
            return this.self();
        }

        public B page(PageInfo page) {
            this.page = page;
            return this.self();
        }

        public String toString() {
            return "FspRequest.FspRequestBuilder(filter=" + this.filter + ", sort=" + this.sort + ", page=" + this.page + ")";
        }
    }
}

