/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.core;

import java.util.List;
import java.util.function.Function;
import pl.execon.fsp.core.FspRequest;

public class FspResponse<T> {
    List<T> content;
    FspResponseInfo info;

    public FspResponse(List<T> content) {
        this.content = content;
        this.info = new FspResponseInfo(Long.valueOf(content.size()));
    }

    public FspResponse(FspRequest request, List<T> content, long totalElementsCount) {
        this.content = content;
        this.info = new FspResponseInfo(request.getPage().number, totalElementsCount, this.pagesTotal(request, totalElementsCount));
    }

    private FspResponse(List<T> content, FspResponseInfo info) {
        this.content = content;
        this.info = info;
    }

    public <U> FspResponse<U> map(Function<List<T>, List<U>> conversion) {
        return new FspResponse<U>(conversion.apply(this.content), this.info);
    }

    public Long getElementsCount() {
        return this.info.totalElements;
    }

    public Long getTotalPages() {
        return this.info.totalPages;
    }

    private Long pagesTotal(FspRequest request, long elementsTotal) {
        return (long)Math.ceil(1.0 * (double)elementsTotal / (double)request.getPage().size);
    }

    public List<T> getContent() {
        return this.content;
    }

    public FspResponseInfo getInfo() {
        return this.info;
    }

    public FspResponse() {
    }

    public String toString() {
        return "FspResponse(content=" + this.getContent() + ", info=" + this.getInfo() + ")";
    }

    static class FspResponseInfo {
        Integer currentPage;
        Long totalElements;
        Long totalPages;

        private FspResponseInfo(Long totalElements) {
            this.totalElements = totalElements;
        }

        public Integer getCurrentPage() {
            return this.currentPage;
        }

        public Long getTotalElements() {
            return this.totalElements;
        }

        public Long getTotalPages() {
            return this.totalPages;
        }

        public FspResponseInfo() {
        }

        public FspResponseInfo(Integer currentPage, Long totalElements, Long totalPages) {
            this.currentPage = currentPage;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }
    }
}

