/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.mongo;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import pl.execon.fsp.core.FilterInfo;
import pl.execon.fsp.core.FspFilterOperator;
import pl.execon.fsp.core.FspRequest;
import pl.execon.fsp.core.SortInfo;

class MongoFspRequestResolver {
    private final FspRequest fspRequest;
    private final Query query;

    public MongoFspRequestResolver(FspRequest fspRequest) {
        this.fspRequest = fspRequest;
        this.query = new Query();
    }

    public Query asQuery() {
        this.addFiltering();
        this.addPaginationAndSorting();
        return this.query;
    }

    private void addFiltering() {
        if (Objects.isNull(this.fspRequest.getFilter()) || this.fspRequest.getFilter().isEmpty()) {
            return;
        }
        List<Criteria> orCriteria = this.filterCriteria(filterInfo -> FspFilterOperator.OR.equals((Object)filterInfo.getOperator()));
        Criteria orCriteriaJoined = this.joinCriteria(orCriteria, criteria -> new Criteria().orOperator(criteria));
        List<Criteria> andCriteria = this.filterCriteria(filterInfo -> Objects.isNull(filterInfo.getOperator()) || FspFilterOperator.AND.equals((Object)filterInfo.getOperator()));
        andCriteria.add(orCriteriaJoined);
        Criteria andCriteriaJoined = this.joinCriteria(andCriteria, criteria -> new Criteria().andOperator(criteria));
        this.query.addCriteria((CriteriaDefinition)andCriteriaJoined);
    }

    private List<Criteria> filterCriteria(Predicate<FilterInfo> condition) {
        return this.fspRequest.getFilter().stream().filter(condition).map(this::asCriteria).collect(Collectors.toList());
    }

    private Criteria joinCriteria(List<Criteria> criterias, Function<Criteria[], Criteria> joiner) {
        Criteria criteria;
        switch (criterias.size()) {
            case 0: {
                criteria = new Criteria();
                break;
            }
            case 1: {
                criteria = criterias.get(0);
                break;
            }
            default: {
                criteria = joiner.apply(criterias.toArray(new Criteria[0]));
            }
        }
        return criteria;
    }

    private void addPaginationAndSorting() {
        Sort sorting;
        Sort sort = sorting = Objects.isNull(this.fspRequest.getSort()) ? Sort.unsorted() : Sort.by(this.fspRequest.getSort().stream().map(this::asOrder).collect(Collectors.toList()));
        if (Objects.nonNull(this.fspRequest.getPage())) {
            this.query.with((Pageable)PageRequest.of((int)this.fspRequest.getPage().getNumber(), (int)(this.fspRequest.getPage().getSize() - 0), (Sort)sorting));
        } else {
            this.query.with(sorting);
        }
    }

    private Sort.Order asOrder(SortInfo sortInfo) {
        return SortInfo.Direction.DESC.equals((Object)sortInfo.getDirection()) ? Sort.Order.desc((String)sortInfo.getBy()) : Sort.Order.asc((String)sortInfo.getBy());
    }

    private Criteria asCriteria(FilterInfo filterInfo) {
        Criteria field = Criteria.where((String)filterInfo.getBy());
        Object value = filterInfo.getValue();
        if (this.isValidLocalDateTime(value.toString())) {
            value = Date.from(LocalDateTime.parse(value.toString(), DateTimeFormatter.ISO_DATE_TIME).atZone(ZoneId.systemDefault()).toInstant());
        }
        Criteria criteria = new Criteria();
        switch (filterInfo.getOperation()) {
            case EQUALS: {
                criteria = field.is(value);
                break;
            }
            case NOT_EQUALS: {
                criteria = field.ne(value);
                break;
            }
            case IN: {
                criteria = field.in((Collection)((List)value));
                break;
            }
            case NOT_IN: {
                criteria = field.nin((Collection)((List)value));
                break;
            }
            case GREATER_THAN: {
                criteria = field.gt(value);
                break;
            }
            case LESS_THAN: {
                criteria = field.lt(value);
                break;
            }
            case GREATER_OR_EQUALS: {
                criteria = field.gte(value);
                break;
            }
            case LESS_OR_EQUALS: {
                criteria = field.lte(value);
                break;
            }
            case CONTAINS: {
                criteria = field.regex(Pattern.compile(value.toString(), 66));
            }
        }
        return criteria;
    }

    private boolean isValidLocalDateTime(String dateStr) {
        try {
            LocalDateTime.parse(dateStr, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }
}

