/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational;

import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import pl.execon.fsp.core.FspRequest;
import pl.execon.fsp.core.SortInfo;

class FilteringAndSortingSpecification {
    private final Sort sort;
    private final PageRequest pageRequest;

    public FilteringAndSortingSpecification(FspRequest fspRequest) {
        this.sort = this.extractSort(fspRequest);
        this.pageRequest = this.extractPageRequest(fspRequest);
    }

    private Sort extractSort(FspRequest fspRequest) {
        return Objects.isNull(fspRequest.getSort()) ? Sort.unsorted() : Sort.by(fspRequest.getSort().stream().map(this::asOrder).collect(Collectors.toList()));
    }

    private PageRequest extractPageRequest(FspRequest fspRequest) {
        if (Objects.nonNull(fspRequest.getPage())) {
            return PageRequest.of((int)fspRequest.getPage().getNumber(), (int)(fspRequest.getPage().getSize() - 0), (Sort)this.sort);
        }
        return null;
    }

    private Sort.Order asOrder(SortInfo sortInfo) {
        return SortInfo.Direction.DESC.equals((Object)sortInfo.getDirection()) ? Sort.Order.desc((String)sortInfo.getBy()) : Sort.Order.asc((String)sortInfo.getBy());
    }

    public Sort getSort() {
        return this.sort;
    }

    public PageRequest getPageRequest() {
        return this.pageRequest;
    }
}

