/*
 * Decompiled with CFR 0.152.
 */
package pl.execon.fsp.relational;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import pl.execon.fsp.core.FilterInfo;
import pl.execon.fsp.core.FspFilterOperator;
import pl.execon.fsp.core.FspRequest;
import pl.execon.fsp.relational.exception.FilteringException;
import pl.execon.fsp.relational.predicate.PredicateCreator;

class FilteringSpecification<T>
implements Specification<T> {
    private final transient List<FilterInfo> filters;
    private transient PredicateCreator<T> predicateCreator;
    private transient CriteriaBuilder criteriaBuilder;

    public FilteringSpecification(FspRequest request) {
        this.filters = request.getFilter();
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
        this.predicateCreator = new PredicateCreator<T>(root, criteriaBuilder);
        if (this.filters.isEmpty()) {
            return criteriaBuilder.conjunction();
        }
        return this.filters.stream().map((Function<FilterInfo, PredicateWithSuffix>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$toPredicate$0(pl.execon.fsp.core.FilterInfo ), (Lpl/execon/fsp/core/FilterInfo;)Lpl/execon/fsp/relational/FilteringSpecification$PredicateWithSuffix;)((FilteringSpecification)this)).reduce((BinaryOperator<PredicateWithSuffix>)(BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, join(pl.execon.fsp.relational.FilteringSpecification$PredicateWithSuffix ), (Lpl/execon/fsp/relational/FilteringSpecification$PredicateWithSuffix;Lpl/execon/fsp/relational/FilteringSpecification$PredicateWithSuffix;)Lpl/execon/fsp/relational/FilteringSpecification$PredicateWithSuffix;)()).orElseThrow((Supplier<FilteringException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$toPredicate$1(), ()Lpl/execon/fsp/relational/exception/FilteringException;)()).predicate;
    }

    private static /* synthetic */ FilteringException lambda$toPredicate$1() {
        return new FilteringException("Filters are empty");
    }

    private /* synthetic */ PredicateWithSuffix lambda$toPredicate$0(FilterInfo x$0) {
        return new PredicateWithSuffix(x$0);
    }

    class PredicateWithSuffix {
        Predicate predicate;
        FspFilterOperator operator;

        PredicateWithSuffix(FilterInfo filter) {
            this.predicate = FilteringSpecification.this.predicateCreator.toPredicate(filter);
            this.operator = filter.getOperator();
        }

        PredicateWithSuffix join(PredicateWithSuffix anotherPredicate) {
            PredicateWithSuffix predicateWithSuffix = null;
            switch (this.operator) {
                case OR: {
                    Predicate joinedOrPredicate = FilteringSpecification.this.criteriaBuilder.or((Expression)this.predicate, (Expression)anotherPredicate.predicate);
                    predicateWithSuffix = new PredicateWithSuffix(joinedOrPredicate, anotherPredicate.operator);
                    break;
                }
                case AND: {
                    Predicate joinedAndPredicate = FilteringSpecification.this.criteriaBuilder.and((Expression)this.predicate, (Expression)anotherPredicate.predicate);
                    predicateWithSuffix = new PredicateWithSuffix(joinedAndPredicate, anotherPredicate.operator);
                }
            }
            return predicateWithSuffix;
        }

        public PredicateWithSuffix(Predicate predicate, FspFilterOperator operator) {
            this.predicate = predicate;
            this.operator = operator;
        }
    }
}

